/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.operator;

import com.annimon.stream.function.IndexedPredicate;
import com.annimon.stream.iterator.IndexedIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class ObjTakeWhileIndexed<T>
implements Iterator<T> {
    private final IndexedIterator<? extends T> iterator;
    private final IndexedPredicate<? super T> predicate;
    private T next;
    private boolean hasNextInitialized;
    private boolean hasNext;

    public ObjTakeWhileIndexed(@NotNull IndexedIterator<? extends T> iterator, @NotNull IndexedPredicate<? super T> predicate) {
        this.iterator = iterator;
        this.predicate = predicate;
        this.hasNextInitialized = false;
        this.hasNext = true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    @Override
    public boolean hasNext() {
        if (this.hasNextInitialized && !this.hasNext) {
            return false;
        }
        this.hasNextInitialized = true;
        this.hasNext = this.iterator.hasNext();
        if (this.hasNext) {
            int nextIndex = this.iterator.getIndex();
            this.next = this.iterator.next();
            this.hasNext = this.predicate.test(nextIndex, this.next);
        }
        return this.hasNext;
    }

    @Override
    public T next() {
        if (this.hasNextInitialized && !this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.next;
    }
}

