/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.cstore;

import com.antgroup.geaflow.store.cstore.CStoreEdgeIterator;
import com.antgroup.geaflow.store.cstore.CStoreVertexAndEdgeIterator;
import com.antgroup.geaflow.store.cstore.CStoreVertexIterator;
import com.antgroup.geaflow.store.cstore.EdgeContainer;
import com.antgroup.geaflow.store.cstore.NativeObject;
import com.antgroup.geaflow.store.cstore.VertexAndEdge;
import com.antgroup.geaflow.store.cstore.VertexContainer;
import java.util.Map;

public class NativeGraphStore
extends NativeObject {
    protected NativeGraphStore(String name, int shard, Map<String, String> config) {
        super(NativeGraphStore.construct(name, shard, config));
    }

    static native long construct(String var0, int var1, Map<String, String> var2);

    private static native void flush(long var0);

    private static native void close(long var0);

    private static native void compact(long var0);

    private static native void archive(long var0, long var2);

    private static native void recover(long var0, long var2);

    public void flush() {
        NativeGraphStore.flush(this.nativeHandle);
    }

    @Override
    public void close() {
        if (this.owningHandle_.compareAndSet(true, false)) {
            NativeGraphStore.close(this.nativeHandle);
            this.disposeInternal(this.nativeHandle);
        }
    }

    public void compact() {
        NativeGraphStore.compact(this.nativeHandle);
    }

    public void archive(long version) {
        NativeGraphStore.archive(this.nativeHandle, version);
    }

    public void recover(long version) {
        NativeGraphStore.recover(this.nativeHandle, version);
    }

    private static native void addVertex(long var0, byte[] var2, long var3, String var5, byte[] var6);

    private native long getVertex(long var1, byte[] var3);

    private native long getVertexWithPushdown(long var1, byte[] var3, byte[] var4);

    private native long scanVertex(long var1);

    private native long scanVertexWithPushdown(long var1, byte[] var3);

    private native long scanVertexWithKeys(long var1, byte[][] var3, int var4);

    private native long scanVertexWithKeysAndPushdown(long var1, byte[][] var3, int var4, byte[] var5);

    public void addVertex(VertexContainer container) {
        NativeGraphStore.addVertex(this.nativeHandle, container.id, container.ts, container.label, container.property);
    }

    public CStoreVertexIterator getVertex(byte[] key) {
        long handler = this.getVertex(this.nativeHandle, key);
        return new CStoreVertexIterator(handler);
    }

    public CStoreVertexIterator getVertex(byte[] key, byte[] pushdown) {
        long handler = this.getVertexWithPushdown(this.nativeHandle, key, pushdown);
        return new CStoreVertexIterator(handler);
    }

    public CStoreVertexIterator scanVertex() {
        long handler = this.scanVertex(this.nativeHandle);
        return new CStoreVertexIterator(handler);
    }

    public CStoreVertexIterator scanVertex(byte[] pushdown) {
        long handler = this.scanVertexWithPushdown(this.nativeHandle, pushdown);
        return new CStoreVertexIterator(handler);
    }

    public CStoreVertexIterator scanVertex(byte[][] keys) {
        long handler = this.scanVertexWithKeys(this.nativeHandle, keys, keys.length);
        return new CStoreVertexIterator(handler);
    }

    public CStoreVertexIterator scanVertex(byte[][] keys, byte[] pushdown) {
        long handler = this.scanVertexWithKeysAndPushdown(this.nativeHandle, keys, keys.length, pushdown);
        return new CStoreVertexIterator(handler);
    }

    private static native void addEdge(long var0, byte[] var2, long var3, String var5, boolean var6, byte[] var7, byte[] var8);

    private native long getEdges(long var1, byte[] var3);

    private native long getEdgesWithPushdown(long var1, byte[] var3, byte[] var4);

    private native long scanEdges(long var1);

    private native long scanEdgesWithPushdown(long var1, byte[] var3);

    private native long scanEdgesWithKeys(long var1, byte[][] var3, int var4);

    private native long scanEdgesWithKeysAndPushdown(long var1, byte[][] var3, int var4, byte[] var5);

    public void addEdge(EdgeContainer container) {
        NativeGraphStore.addEdge(this.nativeHandle, container.sid, container.ts, container.label, container.isOut, container.tid, container.property);
    }

    public CStoreEdgeIterator getEdges(byte[] key) {
        long iteratorHandler = this.getEdges(this.nativeHandle, key);
        return new CStoreEdgeIterator(iteratorHandler);
    }

    public CStoreEdgeIterator getEdges(byte[] key, byte[] pushdown) {
        long iteratorHandler = this.getEdgesWithPushdown(this.nativeHandle, key, pushdown);
        return new CStoreEdgeIterator(iteratorHandler);
    }

    public CStoreEdgeIterator scanEdges() {
        long handler = this.scanEdges(this.nativeHandle);
        return new CStoreEdgeIterator(handler);
    }

    public CStoreEdgeIterator scanEdges(byte[] pushdown) {
        long handler = this.scanEdgesWithPushdown(this.nativeHandle, pushdown);
        return new CStoreEdgeIterator(handler);
    }

    public CStoreEdgeIterator scanEdges(byte[][] keys) {
        long handler = this.scanEdgesWithKeys(this.nativeHandle, keys, keys.length);
        return new CStoreEdgeIterator(handler);
    }

    public CStoreEdgeIterator scanEdges(byte[][] keys, byte[] pushdown) {
        long handler = this.scanEdgesWithKeysAndPushdown(this.nativeHandle, keys, keys.length, pushdown);
        return new CStoreEdgeIterator(handler);
    }

    private native long[] getVertexAndEdge(long var1, byte[] var3);

    private native long[] getVertexAndEdgeWithPushdown(long var1, byte[] var3, byte[] var4);

    private native long scanVertexAndEdge(long var1);

    private native long scanVertexAndEdgeWithPushdown(long var1, byte[] var3);

    private native long scanVertexAndEdgeWithKeys(long var1, byte[][] var3, int var4);

    private native long scanVertexAndEdgeWithKeysAndPushdown(long var1, byte[][] var3, int var4, byte[] var5);

    public VertexAndEdge getVertexAndEdge(byte[] key) {
        long[] addr = this.getVertexAndEdge(this.nativeHandle, key);
        return new VertexAndEdge(key, addr[0], addr[1]);
    }

    public VertexAndEdge getVertexAndEdge(byte[] key, byte[] pushdown) {
        long[] addr = this.getVertexAndEdgeWithPushdown(this.nativeHandle, key, pushdown);
        return new VertexAndEdge(key, addr[0], addr[1]);
    }

    public CStoreVertexAndEdgeIterator scanVertexAndEdge() {
        long handler = this.scanVertexAndEdge(this.nativeHandle);
        return new CStoreVertexAndEdgeIterator(handler);
    }

    public CStoreVertexAndEdgeIterator scanVertexAndEdge(byte[] pushdown) {
        long handler = this.scanVertexAndEdgeWithPushdown(this.nativeHandle, pushdown);
        return new CStoreVertexAndEdgeIterator(handler);
    }

    public CStoreVertexAndEdgeIterator scanVertexAndEdge(byte[][] keys) {
        long iteratorHandler = this.scanVertexAndEdgeWithKeys(this.nativeHandle, keys, keys.length);
        return new CStoreVertexAndEdgeIterator(iteratorHandler);
    }

    public CStoreVertexAndEdgeIterator scanVertexAndEdge(byte[][] keys, byte[] pushdown) {
        long iteratorHandler = this.scanVertexAndEdgeWithKeysAndPushdown(this.nativeHandle, keys, keys.length, pushdown);
        return new CStoreVertexAndEdgeIterator(iteratorHandler);
    }

    @Override
    protected native void disposeInternal(long var1);
}

