/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.store.cstore;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class NativeObject
implements AutoCloseable {
    private static final AtomicReference<LibraryState> libraryLoaded = new AtomicReference<LibraryState>(LibraryState.NOT_LOADED);
    protected final long nativeHandle;
    protected final AtomicBoolean owningHandle_;

    public static void loadLibrary() {
        if (libraryLoaded.get() == LibraryState.LOADED) {
            return;
        }
        if (libraryLoaded.compareAndSet(LibraryState.NOT_LOADED, LibraryState.LOADING)) {
            try {
                NativeObject.doLoadLibrary();
            }
            catch (IOException e) {
                libraryLoaded.set(LibraryState.NOT_LOADED);
                throw new UncheckedIOException("Unable to load the cstore library", e);
            }
            libraryLoaded.set(LibraryState.LOADED);
            return;
        }
        while (libraryLoaded.get() == LibraryState.LOADING) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void doLoadLibrary() throws IOException {
        try {
            System.loadLibrary("geaflow_cstore");
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            NativeObject.doLoadBundledLibrary();
            return;
        }
    }

    private static void doLoadBundledLibrary() throws IOException {
        String libraryPath = NativeObject.bundledLibraryPath();
        try (InputStream is = NativeObject.class.getClassLoader().getResourceAsStream(libraryPath);){
            int dot = libraryPath.indexOf(46);
            File tmpFile = File.createTempFile(libraryPath.substring(0, dot), libraryPath.substring(dot));
            tmpFile.deleteOnExit();
            Files.copy(is, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            System.load(tmpFile.getAbsolutePath());
        }
    }

    private static String bundledLibraryPath() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        arch = arch.contains("aarch64") ? "arm64" : "x86_64";
        StringBuilder path = new StringBuilder();
        if (!os.startsWith("windows")) {
            path.append("lib");
        }
        path.append("geaflow_cstore").append("-").append(arch);
        if (os.startsWith("windows")) {
            path.append(".dll");
        } else if (os.startsWith("mac")) {
            path.append(".dylib");
        } else {
            path.append(".so");
        }
        return path.toString();
    }

    protected NativeObject(long nativeHandle) {
        this.nativeHandle = nativeHandle;
        this.owningHandle_ = new AtomicBoolean(true);
    }

    public boolean isOwningHandle() {
        return this.owningHandle_.get();
    }

    @Override
    public void close() {
        if (this.owningHandle_.compareAndSet(true, false)) {
            this.disposeInternal(this.nativeHandle);
        }
    }

    protected abstract void disposeInternal(long var1);

    static {
        NativeObject.loadLibrary();
    }

    private static enum LibraryState {
        NOT_LOADED,
        LOADING,
        LOADED;

    }
}

