/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.api.partition.graph.edge;

import com.antgroup.geaflow.api.partition.IPartition;
import com.antgroup.geaflow.api.partition.graph.IGraphPartitioner;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;

public class VertexCentricPartitioner<K, VV, EV>
implements IGraphPartitioner<K, VV, EV, IVertex<K, VV>, IEdge<K, EV>> {
    @Override
    public IPartition getVertexPartitioner() {
        return new DefaultVertexPartition();
    }

    @Override
    public IPartition getEdgePartitioner() {
        return new DefaultEdgePartition();
    }

    static class DefaultEdgePartition<K, EV>
    implements IPartition<IEdge<K, EV>> {
        DefaultEdgePartition() {
        }

        @Override
        public int[] partition(IEdge<K, EV> value, int numPartition) {
            return new int[]{Math.abs(value.getSrcId().hashCode() % numPartition)};
        }
    }

    static class DefaultVertexPartition<K, VV>
    implements IPartition<IVertex<K, VV>> {
        DefaultVertexPartition() {
        }

        @Override
        public int[] partition(IVertex<K, VV> value, int numPartition) {
            return new int[]{Math.abs(value.getId().hashCode() % numPartition)};
        }
    }
}

