/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.env;

import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.config.keys.FrameworkConfigKeys;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.env.Environment;
import com.antgroup.geaflow.env.IEnvironment;
import com.antgroup.geaflow.env.args.EnvironmentArgumentParser;
import com.antgroup.geaflow.env.args.IEnvironmentArgsParser;
import com.antgroup.geaflow.state.StoreType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentFactory.class);

    public static Environment onLocalEnvironment() {
        return EnvironmentFactory.onLocalEnvironment(new String[0]);
    }

    public static Environment onLocalEnvironment(String[] args) {
        IEnvironmentArgsParser argsParser = EnvironmentFactory.loadEnvironmentArgsParser();
        HashMap<String, String> config = new HashMap<String, String>(argsParser.parse(args));
        config.put(ExecutionConfigKeys.RUN_LOCAL_MODE.getKey(), Boolean.TRUE.toString());
        config.put(FrameworkConfigKeys.SYSTEM_STATE_BACKEND_TYPE.getKey(), StoreType.MEMORY.name());
        if (!config.containsKey(FrameworkConfigKeys.SYSTEM_OFFSET_BACKEND_TYPE.getKey())) {
            config.put(FrameworkConfigKeys.SYSTEM_OFFSET_BACKEND_TYPE.getKey(), StoreType.MEMORY.name());
        }
        Environment environment = (Environment)EnvironmentFactory.loadEnvironment(IEnvironment.EnvType.LOCAL);
        environment.getEnvironmentContext().withConfig(config);
        return environment;
    }

    public static Environment onAntEnvironment() {
        return (Environment)EnvironmentFactory.loadEnvironment(IEnvironment.EnvType.RAY);
    }

    public static Environment onAntEnvironment(String[] args) {
        Environment environment = (Environment)EnvironmentFactory.loadEnvironment(IEnvironment.EnvType.RAY);
        IEnvironmentArgsParser argsParser = EnvironmentFactory.loadEnvironmentArgsParser();
        environment.getEnvironmentContext().withConfig(argsParser.parse(args));
        return environment;
    }

    public static Environment onK8SEnvironment() {
        return (Environment)EnvironmentFactory.loadEnvironment(IEnvironment.EnvType.K8S);
    }

    public static Environment onK8SEnvironment(String[] args) {
        Environment environment = (Environment)EnvironmentFactory.loadEnvironment(IEnvironment.EnvType.K8S);
        IEnvironmentArgsParser argsParser = EnvironmentFactory.loadEnvironmentArgsParser();
        environment.getEnvironmentContext().withConfig(argsParser.parse(args));
        return environment;
    }

    private static IEnvironment loadEnvironment(IEnvironment.EnvType envType) {
        ServiceLoader<IEnvironment> contextLoader = ServiceLoader.load(IEnvironment.class);
        for (IEnvironment environment : contextLoader) {
            if (environment.getEnvType() != envType) continue;
            LOGGER.info("loaded IEnvironment implementation {}", (Object)environment);
            return environment;
        }
        LOGGER.error("NOT found IEnvironment implementation with type:{}", (Object)envType);
        throw new GeaflowRuntimeException(RuntimeErrors.INST.spiNotFoundError(IEnvironment.class.getSimpleName()));
    }

    private static IEnvironmentArgsParser loadEnvironmentArgsParser() {
        ServiceLoader<IEnvironmentArgsParser> contextLoader = ServiceLoader.load(IEnvironmentArgsParser.class);
        Iterator<IEnvironmentArgsParser> contextIterable = contextLoader.iterator();
        boolean hasNext = contextIterable.hasNext();
        IEnvironmentArgsParser argsParser = hasNext ? contextIterable.next() : new EnvironmentArgumentParser();
        LOGGER.info("loaded IEnvironmentArgsParser implementation {}", (Object)argsParser);
        return argsParser;
    }
}

