/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.env.args;

import com.antgroup.geaflow.common.config.ConfigKey;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.env.args.IEnvironmentArgsParser;
import com.antgroup.geaflow.utils.JsonUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentArgumentParser
implements IEnvironmentArgsParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentArgumentParser.class);
    private static final String JOB_ARGS = "job";
    private static final String SYSTEM_ARGS = "system";
    private static final String CLUSTER_ARGS = "cluster";
    private static final String GEAFLOW_PREFIX = "geaflow";
    private static final String STATE_CONFIG = "stateConfig";
    private static final String METRIC_CONFIG = "metricConfig";

    @Override
    public Map<String, String> parse(String[] args) {
        if (args == null || args.length == 0) {
            return Collections.emptyMap();
        }
        LOGGER.warn("user config: {}", Arrays.asList(args));
        Map mainArgs = JsonUtils.parseJson2map((String)StringEscapeUtils.unescapeJava((String)args[0]));
        Map<String, String> systemArgs = null;
        if (mainArgs.containsKey(SYSTEM_ARGS)) {
            systemArgs = this.parseSystemArgs((String)mainArgs.remove(SYSTEM_ARGS));
        }
        Map userArgs = null;
        if (mainArgs.containsKey(JOB_ARGS)) {
            userArgs = JsonUtils.parseJson2map((String)((String)mainArgs.remove(JOB_ARGS)));
        }
        if (systemArgs != null && userArgs != null) {
            Set<String> systemArgsKeys = systemArgs.keySet();
            Set userArgsKeys = userArgs.keySet();
            if (userArgsKeys.stream().anyMatch(systemArgsKeys::contains)) {
                throw new GeaflowRuntimeException(RuntimeErrors.INST.keyConflictsError(userArgsKeys, systemArgsKeys));
            }
        }
        Map clusterArgs = null;
        if (mainArgs.containsKey(CLUSTER_ARGS)) {
            clusterArgs = JsonUtils.parseJson2map((String)((String)mainArgs.remove(CLUSTER_ARGS)));
        }
        LOGGER.info("build Env with systemArgs: {}, ", (Object)JsonUtils.toJsonString(systemArgs));
        LOGGER.info("build Env with userArgs: {}", (Object)JsonUtils.toJsonString((Object)userArgs));
        LOGGER.info("build Env with clusterArgs: {}", (Object)JsonUtils.toJsonString((Object)clusterArgs));
        HashMap<String, String> envConfig = new HashMap<String, String>();
        if (systemArgs != null) {
            envConfig.putAll(systemArgs);
        }
        if (clusterArgs != null) {
            envConfig.putAll(clusterArgs);
        }
        if (userArgs != null) {
            envConfig.putAll(userArgs);
        }
        LOGGER.info("build envConfig: {}", (Object)JsonUtils.toJsonString(envConfig));
        return envConfig;
    }

    private Map<String, String> parseSystemArgs(String jsonStr) {
        Map systemArgs = JsonUtils.parseJson2map((String)jsonStr);
        EnvironmentArgumentParser.ensureConfigExist(systemArgs, ExecutionConfigKeys.JOB_APP_NAME);
        EnvironmentArgumentParser.ensureConfigExist(systemArgs, ExecutionConfigKeys.JOB_UNIQUE_ID);
        HashMap<String, String> finalSystemArgs = new HashMap<String, String>();
        EnvironmentArgumentParser.fillSystemConfig(finalSystemArgs, systemArgs);
        if (systemArgs.containsKey(STATE_CONFIG)) {
            Map stateConfig = JsonUtils.parseJson2map((String)((String)systemArgs.remove(STATE_CONFIG)));
            EnvironmentArgumentParser.fillSystemConfig(finalSystemArgs, stateConfig);
        }
        if (systemArgs.containsKey(METRIC_CONFIG)) {
            Map metricConfig = JsonUtils.parseJson2map((String)((String)systemArgs.remove(METRIC_CONFIG)));
            EnvironmentArgumentParser.fillSystemConfig(finalSystemArgs, metricConfig);
        }
        return finalSystemArgs;
    }

    private static void ensureConfigExist(Map<String, String> config, ConfigKey configKey) {
        String key = configKey.getKey();
        if (!config.containsKey(key) || !StringUtils.isNotBlank((CharSequence)config.get(key))) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.configKeyNotFound(key));
        }
    }

    private static void fillSystemConfig(Map<String, String> finalSystemArgs, Map<String, String> tmp) {
        for (Map.Entry<String, String> entry : tmp.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith(GEAFLOW_PREFIX)) {
                finalSystemArgs.put(key, value);
                continue;
            }
            LOGGER.warn("ignore nonstandard system config: {} {}", (Object)key, (Object)value);
        }
    }
}

