/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.view;

import com.antgroup.geaflow.api.partition.graph.vertex.GraphPartitioner;
import com.antgroup.geaflow.model.graph.meta.GraphMetaType;
import com.antgroup.geaflow.utils.math.MathUtil;
import com.antgroup.geaflow.view.IViewDesc;
import com.antgroup.geaflow.view.graph.GraphViewDesc;
import com.google.common.base.Preconditions;
import java.util.Map;

public class GraphViewBuilder {
    public static final String DEFAULT_GRAPH = "default_graph";
    private final String viewName;
    private int shardNum;
    private IViewDesc.BackendType backend;
    private GraphPartitioner partitioner;
    private GraphMetaType graphMetaType;
    private Map props;
    private long latestVersion = -1L;

    private GraphViewBuilder(String name) {
        this.viewName = name;
    }

    public static GraphViewBuilder createGraphView(String name) {
        return new GraphViewBuilder(name);
    }

    public GraphViewBuilder withShardNum(int shardNum) {
        this.shardNum = shardNum;
        return this;
    }

    public GraphViewBuilder withBackend(IViewDesc.BackendType backend) {
        this.backend = backend;
        return this;
    }

    public GraphViewBuilder withSchema(GraphMetaType graphMetaType) {
        this.graphMetaType = graphMetaType;
        return this;
    }

    public GraphViewBuilder withProps(Map props) {
        this.props = props;
        return this;
    }

    public GraphViewBuilder withLatestVersion(long latestVersion) {
        this.latestVersion = latestVersion;
        return this;
    }

    public GraphViewDesc build() {
        Preconditions.checkArgument((this.viewName != null ? 1 : 0) != 0, (Object)"this name is empty");
        Preconditions.checkArgument((boolean)MathUtil.isPowerOf2((int)this.shardNum), (Object)"this shardNum must be power of 2");
        Preconditions.checkArgument((this.backend != null ? 1 : 0) != 0, (Object)"this backend is null");
        return new GraphViewDesc(this.viewName, this.shardNum, this.backend, this.partitioner, this.graphMetaType, this.props, this.latestVersion);
    }
}

