/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.view.graph;

import com.antgroup.geaflow.api.graph.PGraphWindow;
import com.antgroup.geaflow.api.pdata.stream.window.PWindowStream;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.view.PView;
import com.antgroup.geaflow.view.graph.GraphViewDesc;
import com.antgroup.geaflow.view.graph.PIncGraphView;
import java.util.Iterator;
import java.util.ServiceLoader;

public interface PGraphView<K, VV, EV>
extends PView {
    public static <K, VV, EV> PGraphView<K, VV, EV> loadPGraphView(GraphViewDesc graphViewDesc) {
        ServiceLoader<PGraphView> contextLoader = ServiceLoader.load(PGraphView.class);
        Iterator<PGraphView> graphViewIterable = contextLoader.iterator();
        if (graphViewIterable.hasNext()) {
            PGraphView pGraphView = graphViewIterable.next();
            pGraphView.init(graphViewDesc);
            return pGraphView;
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.spiNotFoundError(PGraphView.class.getSimpleName()));
    }

    public PGraphView<K, VV, EV> init(GraphViewDesc var1);

    public PIncGraphView<K, VV, EV> appendVertex(PWindowStream<IVertex<K, VV>> var1);

    public PIncGraphView<K, VV, EV> appendEdge(PWindowStream<IEdge<K, EV>> var1);

    public PIncGraphView<K, VV, EV> appendGraph(PWindowStream<IVertex<K, VV>> var1, PWindowStream<IEdge<K, EV>> var2);

    public PGraphWindow<K, VV, EV> snapshot(long var1);
}

