/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.api.pdata;

import com.antgroup.geaflow.api.function.io.SourceFunction;
import com.antgroup.geaflow.api.pdata.base.PSource;
import com.antgroup.geaflow.api.pdata.stream.PStream;
import com.antgroup.geaflow.api.pdata.stream.window.PWindowSource;
import com.antgroup.geaflow.api.window.IWindow;
import com.antgroup.geaflow.common.encoder.IEncoder;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.pipeline.context.IPipelineContext;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PStreamSource<T>
extends PStream<T>,
PSource {
    public static final Logger LOGGER = LoggerFactory.getLogger(PStreamSource.class);

    public static <T> PStreamSource<T> from(IPipelineContext pipelineContext, SourceFunction<T> sourceFunction, IWindow<T> window) {
        LOGGER.info("load PStreamSource SPI Implementation");
        ServiceLoader<PStreamSource> serviceLoader = ServiceLoader.load(PStreamSource.class);
        Iterator<PStreamSource> iterator = serviceLoader.iterator();
        boolean hasImpl = iterator.hasNext();
        if (hasImpl) {
            PStreamSource streamSource = iterator.next();
            return streamSource.build(pipelineContext, sourceFunction, window);
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.spiNotFoundError(PStreamSource.class.getSimpleName()));
    }

    public PStreamSource<T> build(IPipelineContext var1, SourceFunction<T> var2, IWindow<T> var3);

    public PWindowSource<T> window(IWindow<T> var1);

    @Override
    public PStreamSource<T> withConfig(Map var1);

    @Override
    public PStreamSource<T> withConfig(String var1, String var2);

    @Override
    public PStreamSource<T> withName(String var1);

    @Override
    public PStreamSource<T> withParallelism(int var1);

    @Override
    public PStreamSource<T> withEncoder(IEncoder<T> var1);
}

