/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.pipeline;

import com.antgroup.geaflow.env.Environment;
import com.antgroup.geaflow.pipeline.IPipelineResult;
import com.antgroup.geaflow.pipeline.callback.TaskCallBack;
import com.antgroup.geaflow.pipeline.service.PipelineService;
import com.antgroup.geaflow.pipeline.task.PipelineTask;
import com.antgroup.geaflow.view.IViewDesc;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Pipeline
implements Serializable {
    private transient Environment environment;
    private List<PipelineTask> pipelineTaskList;
    private List<TaskCallBack> pipelineTaskCallbacks;
    private List<PipelineService> pipelineServices;
    private Map<String, IViewDesc> viewDescMap;

    public Pipeline(Environment environment) {
        this.environment = environment;
        this.environment.addPipeline(this);
        this.viewDescMap = new HashMap<String, IViewDesc>();
        this.pipelineTaskList = new ArrayList<PipelineTask>();
        this.pipelineTaskCallbacks = new ArrayList<TaskCallBack>();
        this.pipelineServices = new ArrayList<PipelineService>();
    }

    public void init() {
    }

    public Pipeline withView(String viewName, IViewDesc viewDesc) {
        this.viewDescMap.put(viewName, viewDesc);
        return this;
    }

    public TaskCallBack submit(PipelineTask pipelineTask) {
        this.pipelineTaskList.add(pipelineTask);
        TaskCallBack taskCallBack = new TaskCallBack();
        this.pipelineTaskCallbacks.add(taskCallBack);
        return taskCallBack;
    }

    public Pipeline start(PipelineService pipelineService) {
        this.pipelineServices.add(pipelineService);
        return this;
    }

    public Pipeline schedule(PipelineTask pipelineTask) {
        this.pipelineTaskList.add(pipelineTask);
        return this;
    }

    public IPipelineResult execute() {
        this.environment.init();
        return this.environment.submit();
    }

    public void shutdown() {
        this.environment.shutdown();
    }

    public List<IViewDesc> getViewDescMap() {
        return this.viewDescMap.values().stream().collect(Collectors.toList());
    }

    public List<PipelineTask> getPipelineTaskList() {
        return this.pipelineTaskList;
    }

    public List<TaskCallBack> getPipelineTaskCallbacks() {
        return this.pipelineTaskCallbacks;
    }

    public List<PipelineService> getPipelineServices() {
        return this.pipelineServices;
    }
}

