/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.view.graph;

import com.antgroup.geaflow.api.partition.graph.vertex.GraphPartitioner;
import com.antgroup.geaflow.model.graph.meta.GraphMetaType;
import com.antgroup.geaflow.view.IViewDesc;
import com.antgroup.geaflow.view.graph.GraphSnapshotDesc;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GraphViewDesc
implements IViewDesc {
    private final String viewName;
    private final int shardNum;
    private final IViewDesc.BackendType backend;
    private final GraphPartitioner partitioner;
    private final GraphMetaType graphMetaType;
    private final Map props;
    private final long currentVersion;

    public GraphViewDesc(String viewName, int shardNum, IViewDesc.BackendType backend, GraphPartitioner partitioner, GraphMetaType graphMetaType, Map props, long currentVersion) {
        this.viewName = Objects.requireNonNull(viewName, "view name is null");
        this.shardNum = shardNum;
        this.backend = backend;
        this.partitioner = partitioner;
        this.graphMetaType = graphMetaType;
        this.props = props;
        this.currentVersion = currentVersion;
    }

    @Override
    public String getName() {
        return this.viewName;
    }

    @Override
    public int getShardNum() {
        return this.shardNum;
    }

    @Override
    public IViewDesc.DataModel getDataModel() {
        return IViewDesc.DataModel.GRAPH;
    }

    @Override
    public IViewDesc.BackendType getBackend() {
        return this.backend;
    }

    @Override
    public Map getViewProps() {
        return this.props == null ? new HashMap() : this.props;
    }

    public GraphMetaType getGraphMetaType() {
        return this.graphMetaType;
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public GraphSnapshotDesc snapshot(long snapshotVersion) {
        assert (!this.isStatic()) : "Only dynamic graph have the snapshot() method.";
        return new GraphSnapshotDesc(this.viewName, this.shardNum, this.backend, this.partitioner, this.graphMetaType, this.props, snapshotVersion);
    }

    public boolean isStatic() {
        return this.currentVersion == 0L;
    }

    public long getCheckpoint(long currentWindowId) {
        if (this.isStatic()) {
            return 0L;
        }
        if (this.currentVersion <= 0L) {
            return Math.max(currentWindowId, 1L);
        }
        return currentWindowId + this.currentVersion;
    }

    public GraphViewDesc asStatic() {
        return new GraphViewDesc(this.viewName, this.shardNum, this.backend, this.partitioner, this.graphMetaType, this.props, 0L);
    }
}

