/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.client;

import com.antgroup.geaflow.cluster.client.IClusterClient;
import com.antgroup.geaflow.cluster.client.callback.ClusterStartedCallback;
import com.antgroup.geaflow.cluster.client.callback.RestClusterStartedCallback;
import com.antgroup.geaflow.cluster.client.callback.SimpleClusterStartedCallback;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.env.ctx.EnvironmentContext;
import com.antgroup.geaflow.env.ctx.IEnvironmentContext;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractClusterClient
implements IClusterClient {
    private static final String MASTER_ID = "_MASTER";
    protected String clusterId;
    protected String masterId;
    protected Configuration config;
    protected ClusterStartedCallback callback;

    @Override
    public void init(IEnvironmentContext environmentContext) {
        EnvironmentContext context = (EnvironmentContext)environmentContext;
        this.config = context.getConfig();
        this.clusterId = this.config.getString(ExecutionConfigKeys.CLUSTER_ID);
        if (StringUtils.isEmpty((CharSequence)this.clusterId)) {
            this.clusterId = UUID.randomUUID().toString();
            this.config.put(ExecutionConfigKeys.CLUSTER_ID, this.clusterId);
        }
        this.masterId = MASTER_ID;
        this.config.setMasterId(this.masterId);
        this.callback = this.createClusterStartedCallback(this.config);
    }

    private ClusterStartedCallback createClusterStartedCallback(Configuration configuration) {
        String callbackUrl = configuration.getString(ExecutionConfigKeys.CLUSTER_STARTED_CALLBACK_URL);
        if (StringUtils.isNotBlank((CharSequence)callbackUrl)) {
            return new RestClusterStartedCallback(configuration, callbackUrl);
        }
        return new SimpleClusterStartedCallback();
    }
}

