/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.client;

import com.antgroup.geaflow.cluster.rpc.impl.RpcMessageEncoder;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.pipeline.IPipelineResult;
import com.antgroup.geaflow.rpc.proto.Driver;
import java.util.Iterator;

public class PipelineResult<R>
implements IPipelineResult<R> {
    private Iterator<Driver.PipelineRes> resultIterator;
    private Boolean success;
    private R result;

    public PipelineResult(Iterator<Driver.PipelineRes> resultIterator) {
        this.resultIterator = resultIterator;
        this.success = null;
    }

    public boolean isSuccess() {
        if (this.success == null) {
            if (!this.resultIterator.hasNext()) {
                throw new GeaflowRuntimeException("not found pipeline result");
            }
            this.result = RpcMessageEncoder.decode(this.resultIterator.next().getPayload());
            if (this.resultIterator.hasNext()) {
                throw new GeaflowRuntimeException("not support more than one result yet");
            }
            this.success = true;
            return true;
        }
        return this.success;
    }

    public R get() {
        if (this.isSuccess()) {
            return this.result;
        }
        throw new GeaflowRuntimeException("failed to get result");
    }
}

