/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.client.callback;

import com.antgroup.geaflow.cluster.client.callback.ClusterStartedCallback;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.DSLConfigKeys;
import com.antgroup.geaflow.utils.HttpUtil;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RestClusterStartedCallback
implements ClusterStartedCallback {
    private static final String GEAFLOW_TOKEN_KEY = "geaflow-token";
    private final Configuration config;
    private final String callbackUrl;
    private final Map<String, String> headers;

    public RestClusterStartedCallback(Configuration config, String url) {
        this.config = config;
        this.callbackUrl = url;
        this.headers = new HashMap<String, String>();
        this.headers.put(GEAFLOW_TOKEN_KEY, config.getString(DSLConfigKeys.GEAFLOW_DSL_CATALOG_TOKEN_KEY, ""));
    }

    @Override
    public void onSuccess(ClusterStartedCallback.ClusterMeta clusterInfo) {
        HttpRequest request = new HttpRequest();
        request.setSuccess(true);
        request.setData(clusterInfo);
        HttpUtil.post((String)this.callbackUrl, (String)new Gson().toJson((Object)request), this.headers);
    }

    @Override
    public void onFailure(Throwable e) {
        HttpRequest request = new HttpRequest();
        request.setSuccess(false);
        request.setMessage(e.getMessage());
        HttpUtil.post((String)this.callbackUrl, (String)new Gson().toJson((Object)request), this.headers);
    }

    static class HttpRequest
    implements Serializable {
        private boolean success;
        private String message;
        private Object data;

        HttpRequest() {
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }
    }
}

