/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.clustermanager;

import com.antgroup.geaflow.cluster.clustermanager.ClusterContext;
import com.antgroup.geaflow.cluster.clustermanager.ClusterId;
import com.antgroup.geaflow.cluster.clustermanager.ContainerExecutorInfo;
import com.antgroup.geaflow.cluster.clustermanager.ExecutorRegisterException;
import com.antgroup.geaflow.cluster.clustermanager.ExecutorRegisteredCallback;
import com.antgroup.geaflow.cluster.clustermanager.IClusterManager;
import com.antgroup.geaflow.cluster.config.ClusterConfig;
import com.antgroup.geaflow.cluster.container.ContainerInfo;
import com.antgroup.geaflow.cluster.driver.DriverInfo;
import com.antgroup.geaflow.cluster.failover.IFailoverStrategy;
import com.antgroup.geaflow.cluster.protocol.OpenContainerEvent;
import com.antgroup.geaflow.cluster.protocol.OpenContainerResponseEvent;
import com.antgroup.geaflow.cluster.rpc.RpcAddress;
import com.antgroup.geaflow.cluster.rpc.RpcClient;
import com.antgroup.geaflow.cluster.rpc.RpcEndpointRef;
import com.antgroup.geaflow.cluster.rpc.RpcEndpointRefFactory;
import com.antgroup.geaflow.cluster.rpc.RpcUtil;
import com.antgroup.geaflow.cluster.rpc.impl.ContainerEndpointRef;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.serialize.SerializerFactory;
import com.antgroup.geaflow.rpc.proto.Container;
import com.antgroup.geaflow.rpc.proto.Master;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClusterManager
implements IClusterManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractClusterManager.class);
    protected String masterId;
    protected ClusterConfig clusterConfig;
    protected ClusterContext clusterContext;
    protected ClusterId clusterInfo;
    protected Map<Integer, ContainerInfo> containerInfos;
    protected Map<Integer, DriverInfo> driverInfos;
    protected Set<Integer> containerIds;
    protected Set<Integer> driverIds;
    protected IFailoverStrategy foStrategy;
    protected CompletableFuture<DriverInfo> driverFuture;
    protected long driverTimeoutSec;
    private AtomicInteger idGenerator;

    @Override
    public void init(ClusterContext clusterContext) {
        this.clusterConfig = clusterContext.getClusterConfig();
        this.driverTimeoutSec = this.clusterConfig.getDriverRegisterTimeoutSec();
        this.containerInfos = new HashMap<Integer, ContainerInfo>();
        this.driverInfos = new HashMap<Integer, DriverInfo>();
        this.clusterContext = clusterContext;
        this.idGenerator = new AtomicInteger(0);
        this.masterId = clusterContext.getConfig().getMasterId();
        this.driverFuture = new CompletableFuture();
        this.containerIds = new HashSet<Integer>();
        this.driverIds = new HashSet<Integer>();
        this.foStrategy = this.buildFoStrategy();
        Preconditions.checkNotNull((Object)this.masterId, (Object)"masterId is not set");
    }

    public ClusterContext getClusterContext() {
        return this.clusterContext;
    }

    protected abstract IFailoverStrategy buildFoStrategy();

    @Override
    public void allocateWorkers(int workerNum) {
        int workersPerContainer = this.clusterConfig.getContainerWorkerNum();
        int containerNum = (workerNum + workersPerContainer - 1) / workersPerContainer;
        LOGGER.info("allocate {} workers in {} containers[{}]", new Object[]{workerNum, containerNum, workersPerContainer});
        this.startContainers(containerNum);
    }

    private void startContainers(int containerNum) {
        for (int i = 0; i < containerNum; ++i) {
            int containerId = this.idGenerator.incrementAndGet();
            this.doStartContainer(containerId, false);
            this.containerIds.add(containerId);
        }
    }

    @Override
    public RpcAddress startDriver() {
        try {
            int driverId = this.idGenerator.incrementAndGet();
            this.doStartDriver(driverId);
            this.driverIds.add(driverId);
            DriverInfo driverInfo = this.driverFuture.get(this.driverTimeoutSec, TimeUnit.SECONDS);
            return new RpcAddress(driverInfo.getHost(), driverInfo.getRpcPort());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new GeaflowRuntimeException((Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.clusterInfo != null) {
            LOGGER.info("close master {}", (Object)this.masterId);
            RpcClient.getInstance().closeMasterConnection(this.masterId);
        }
        for (ContainerInfo containerInfo : this.containerInfos.values()) {
            LOGGER.info("close container {}", (Object)containerInfo.getName());
            RpcClient.getInstance().closeContainerConnection(containerInfo.getName());
        }
        for (DriverInfo driverInfo : this.driverInfos.values()) {
            LOGGER.info("close driver {}", (Object)driverInfo.getName());
            RpcClient.getInstance().closeDriverConnection(driverInfo.getName());
        }
    }

    public void clusterFailover(int componentId) {
        this.foStrategy.doFailover(componentId);
    }

    public Master.RegisterResponse registerContainer(ContainerInfo request) {
        ContainerInfo containerInfo = this.containerInfos.put(request.getId(), request);
        boolean registered = containerInfo == null;
        Master.RegisterResponse response = Master.RegisterResponse.newBuilder().setSuccess(registered).build();
        RpcUtil.asyncExecute(() -> this.openContainer(request));
        return response;
    }

    protected void openContainer(final ContainerInfo containerInfo) {
        ContainerEndpointRef endpointRef = RpcEndpointRefFactory.getInstance().connectContainer(containerInfo.getHost(), containerInfo.getRpcPort());
        final int workerNum = this.clusterConfig.getContainerWorkerNum();
        endpointRef.process(new OpenContainerEvent(workerNum), new RpcEndpointRef.RpcCallback<Container.Response>(){

            @Override
            public void onSuccess(Container.Response response) {
                byte[] payload = response.getPayload().toByteArray();
                OpenContainerResponseEvent openResult = (OpenContainerResponseEvent)SerializerFactory.getKryoSerializer().deserialize(payload);
                ContainerExecutorInfo executorInfo = new ContainerExecutorInfo(containerInfo, openResult.getFirstWorkerIndex(), workerNum);
                AbstractClusterManager.this.handleRegisterResponse(executorInfo, openResult, null);
            }

            @Override
            public void onFailure(Throwable t) {
                AbstractClusterManager.this.handleRegisterResponse(null, null, t);
            }
        });
    }

    public Master.RegisterResponse registerDriver(DriverInfo driverInfo) {
        this.driverInfos.put(driverInfo.getId(), driverInfo);
        boolean registered = this.driverFuture.complete(driverInfo);
        LOGGER.info("driver is registered:{}", (Object)driverInfo);
        return Master.RegisterResponse.newBuilder().setSuccess(registered).build();
    }

    public Map<Integer, ContainerInfo> getContainerInfos() {
        return new HashMap<Integer, ContainerInfo>(this.containerInfos);
    }

    private void handleRegisterResponse(ContainerExecutorInfo executorInfo, OpenContainerResponseEvent response, Throwable e) {
        List<ExecutorRegisteredCallback> callbacks = this.clusterContext.getCallbacks();
        if (e != null || !response.isSuccess()) {
            for (ExecutorRegisteredCallback callback : callbacks) {
                callback.onFailure(new ExecutorRegisterException(e));
            }
        } else {
            for (ExecutorRegisteredCallback callback : callbacks) {
                callback.onSuccess(executorInfo);
            }
        }
    }

    protected abstract void doStartContainer(int var1, boolean var2);

    protected abstract void doStartDriver(int var1);

    public Set<Integer> getContainerIds() {
        return new HashSet<Integer>(this.containerIds);
    }

    public Set<Integer> getDriverIds() {
        return new HashSet<Integer>(this.driverIds);
    }

    public void setContainerIds(Set<Integer> containerIds) {
        this.containerIds = containerIds;
    }

    public void setDriverIds(Set<Integer> driverIds) {
        this.driverIds = driverIds;
    }
}

