/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.clustermanager;

import com.antgroup.geaflow.cluster.clustermanager.ExecutorRegisteredCallback;
import com.antgroup.geaflow.cluster.config.ClusterConfig;
import com.antgroup.geaflow.cluster.heartbeat.HeartbeatManager;
import com.antgroup.geaflow.common.config.Configuration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ClusterContext
implements Serializable {
    private final Configuration config;
    private final ClusterConfig clusterConfig;
    private final List<ExecutorRegisteredCallback> callbacks;
    private HeartbeatManager heartbeatManager;

    public ClusterContext(Configuration configuration) {
        this.config = configuration;
        this.clusterConfig = ClusterConfig.build(configuration);
        this.callbacks = new ArrayList<ExecutorRegisteredCallback>();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public ClusterConfig getClusterConfig() {
        return this.clusterConfig;
    }

    public void addExecutorRegisteredCallback(ExecutorRegisteredCallback callback) {
        this.callbacks.add(callback);
    }

    public List<ExecutorRegisteredCallback> getCallbacks() {
        return this.callbacks;
    }

    public HeartbeatManager getHeartbeatManager() {
        return this.heartbeatManager;
    }

    public void setHeartbeatManager(HeartbeatManager heartbeatManager) {
        this.heartbeatManager = heartbeatManager;
    }
}

