/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.collector;

import com.antgroup.geaflow.cluster.response.ResponseResult;
import com.antgroup.geaflow.collector.AbstractCollector;
import com.antgroup.geaflow.collector.ICollector;
import com.antgroup.geaflow.collector.IResultCollector;
import com.antgroup.geaflow.io.CollectType;
import com.antgroup.geaflow.io.ResponseOutputDesc;
import java.util.ArrayList;
import java.util.List;

public class CollectResponseCollector<T>
extends AbstractCollector
implements IResultCollector<ResponseResult>,
ICollector<T> {
    private int edgeId;
    private CollectType collectorType;
    private String edgeName;
    private final List<T> buffer;
    private final List<T> result;

    public CollectResponseCollector(ResponseOutputDesc outputDesc) {
        super(outputDesc.getOpId());
        this.edgeId = outputDesc.getEdgeId();
        this.collectorType = outputDesc.getType();
        this.edgeName = outputDesc.getEdgeName();
        this.buffer = new ArrayList<T>();
        this.result = new ArrayList<T>();
    }

    public void partition(T value) {
        this.buffer.add(value);
        this.outputMeter.mark();
    }

    public void finish() {
        this.result.clear();
        this.result.addAll(this.buffer);
        this.buffer.clear();
    }

    public String getTag() {
        return this.edgeName;
    }

    public CollectType getType() {
        return this.collectorType;
    }

    public void broadcast(T value) {
    }

    public <KEY> void partition(KEY key, T value) {
        this.partition(value);
    }

    public ResponseResult collectResult() {
        ResponseResult responseResult = new ResponseResult(this.edgeId, this.getType(), new ArrayList<Object>(this.result));
        this.result.clear();
        return responseResult;
    }
}

