/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.collector;

import com.antgroup.geaflow.cluster.collector.CollectResponseCollector;
import com.antgroup.geaflow.cluster.collector.ForwardOutputCollector;
import com.antgroup.geaflow.cluster.collector.IterationOutputCollector;
import com.antgroup.geaflow.collector.ICollector;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.io.ResponseOutputDesc;
import com.antgroup.geaflow.shuffle.ForwardOutputDesc;
import com.antgroup.geaflow.shuffle.IOutputDesc;

public class CollectorFactory {
    public static <T> ICollector<T> create(IOutputDesc outputDesc) {
        switch (outputDesc.getType()) {
            case FORWARD: {
                return new ForwardOutputCollector((ForwardOutputDesc)outputDesc);
            }
            case LOOP: {
                return new IterationOutputCollector((ForwardOutputDesc)outputDesc);
            }
            case RESPONSE: {
                return new CollectResponseCollector((ResponseOutputDesc)outputDesc);
            }
        }
        throw new GeaflowRuntimeException("not support output type {}" + outputDesc.getType());
    }
}

