/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.collector;

import com.antgroup.geaflow.cluster.collector.CloseEmitterRequest;
import com.antgroup.geaflow.cluster.collector.IEmitterRequest;
import com.antgroup.geaflow.cluster.collector.InitEmitterRequest;
import com.antgroup.geaflow.cluster.collector.PipelineOutputEmitter;
import com.antgroup.geaflow.cluster.collector.UpdateEmitterRequest;
import com.antgroup.geaflow.cluster.task.runner.AbstractTaskRunner;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;

public class EmitterRunner
extends AbstractTaskRunner<IEmitterRequest> {
    private final PipelineOutputEmitter outputEmitter;

    public EmitterRunner(Configuration configuration, int index) {
        this.outputEmitter = new PipelineOutputEmitter(configuration, index);
    }

    @Override
    protected void process(IEmitterRequest request) {
        switch (request.getRequestType()) {
            case INIT: {
                this.outputEmitter.init((InitEmitterRequest)request);
                break;
            }
            case UPDATE: {
                this.outputEmitter.update((UpdateEmitterRequest)request);
                break;
            }
            case CLOSE: {
                this.outputEmitter.close((CloseEmitterRequest)request);
                break;
            }
            case CLEAR: {
                this.outputEmitter.clear();
                break;
            }
            default: {
                throw new GeaflowRuntimeException(RuntimeErrors.INST.requestTypeNotSupportError(request.getRequestType().name()));
            }
        }
    }
}

