/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.collector;

import com.antgroup.geaflow.cluster.collector.EmitterRunner;
import com.antgroup.geaflow.cluster.collector.IEmitterRequest;
import com.antgroup.geaflow.cluster.task.service.AbstractTaskService;
import com.antgroup.geaflow.common.config.Configuration;
import com.google.common.base.Preconditions;
import java.io.Serializable;

public class EmitterService
extends AbstractTaskService<IEmitterRequest, EmitterRunner>
implements Serializable {
    private static final String EMITTER_FORMAT = "geaflow-emitter-%d";
    private final int slots;
    private final Configuration configuration;

    public EmitterService(int slots, Configuration configuration) {
        super(EMITTER_FORMAT);
        this.slots = slots;
        this.configuration = configuration;
    }

    protected EmitterRunner[] buildTaskRunner() {
        Preconditions.checkArgument((this.slots > 0 ? 1 : 0) != 0, (Object)"fetcher pool should be larger than 0");
        EmitterRunner[] emitterRunners = new EmitterRunner[this.slots];
        for (int i = 0; i < this.slots; ++i) {
            EmitterRunner runner;
            emitterRunners[i] = runner = new EmitterRunner(this.configuration, i);
        }
        return emitterRunners;
    }
}

