/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.common;

import com.antgroup.geaflow.cluster.rpc.RpcClient;
import com.antgroup.geaflow.cluster.rpc.impl.RpcServiceImpl;
import com.antgroup.geaflow.cluster.system.ClusterMetaStore;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.utils.ProcessUtil;
import com.antgroup.geaflow.ha.service.HAServiceFactory;
import com.antgroup.geaflow.ha.service.IHAService;
import com.antgroup.geaflow.ha.service.ResourceData;
import com.antgroup.geaflow.metrics.common.MetricGroupRegistry;
import com.antgroup.geaflow.metrics.common.api.MetricGroup;
import com.antgroup.geaflow.shuffle.service.ShuffleManager;
import com.antgroup.geaflow.stats.collector.StatsCollectorFactory;

public abstract class AbstractComponent {
    protected int id;
    protected String name;
    protected String masterId;
    protected int rpcPort;
    protected Configuration configuration;
    protected IHAService haService;
    protected RpcServiceImpl rpcService;
    protected MetricGroup metricGroup;
    protected MetricGroupRegistry metricGroupRegistry;

    public AbstractComponent() {
    }

    public AbstractComponent(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public void init(int id, String name, Configuration configuration) {
        this.id = id;
        this.name = name;
        this.configuration = configuration;
        this.masterId = configuration.getMasterId();
        this.metricGroupRegistry = MetricGroupRegistry.getInstance((Configuration)configuration);
        this.metricGroup = this.metricGroupRegistry.getMetricGroup();
        this.haService = HAServiceFactory.getService((Configuration)configuration);
        RpcClient.init(configuration);
        ClusterMetaStore.init(id, configuration);
        StatsCollectorFactory.init((Configuration)configuration);
    }

    protected abstract void startRpcService();

    protected void registerHAService() {
        ResourceData resourceData = new ResourceData();
        resourceData.setProcessId(ProcessUtil.getProcessId());
        resourceData.setHost(ProcessUtil.getHostIp());
        resourceData.setRpcPort(this.rpcPort);
        ShuffleManager shuffleManager = ShuffleManager.getInstance();
        if (shuffleManager != null) {
            resourceData.setShufflePort(shuffleManager.getShufflePort());
        }
        this.haService.register(this.name, resourceData);
    }

    public void close() {
        if (this.haService != null) {
            this.haService.close();
        }
        if (this.rpcService != null) {
            this.rpcService.stopService();
        }
        ClusterMetaStore.close();
    }

    public void waitTermination() {
        this.rpcService.waitTermination();
    }
}

