/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.common;

import com.antgroup.geaflow.cluster.common.AbstractComponent;
import com.antgroup.geaflow.cluster.common.ComponentInfo;
import com.antgroup.geaflow.cluster.exception.ExceptionClient;
import com.antgroup.geaflow.cluster.exception.ExceptionCollectService;
import com.antgroup.geaflow.cluster.heartbeat.HeartbeatClient;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.shuffle.service.ShuffleManager;

public abstract class AbstractContainer
extends AbstractComponent {
    protected HeartbeatClient heartbeatClient;
    protected ExceptionCollectService exceptionCollectService;

    public AbstractContainer(int rpcPort) {
        super(rpcPort);
    }

    @Override
    public void init(int id, String containerNamePrefix, Configuration configuration) {
        this.name = String.format("%s%s", containerNamePrefix, id);
        super.init(id, this.name, configuration);
        this.startRpcService();
        ShuffleManager.init((Configuration)configuration);
        ExceptionClient.init(id, this.masterId);
        this.heartbeatClient = new HeartbeatClient(id, this.name, configuration);
        this.exceptionCollectService = new ExceptionCollectService();
    }

    protected void registerToMaster() {
        this.heartbeatClient.registerToMaster(this.masterId, this.buildComponentInfo());
    }

    protected abstract ComponentInfo buildComponentInfo();

    @Override
    public void close() {
        super.close();
        if (this.exceptionCollectService != null) {
            this.exceptionCollectService.shutdown();
        }
        if (this.heartbeatClient != null) {
            this.heartbeatClient.close();
        }
    }
}

