/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.container;

import com.antgroup.geaflow.cluster.common.IReliableContext;
import com.antgroup.geaflow.cluster.common.ReliableContainerContext;
import com.antgroup.geaflow.cluster.protocol.EventType;
import com.antgroup.geaflow.cluster.protocol.IComposeEvent;
import com.antgroup.geaflow.cluster.protocol.IEvent;
import com.antgroup.geaflow.cluster.protocol.IHighAvailableEvent;
import com.antgroup.geaflow.cluster.system.ClusterMetaStore;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.ha.runtime.HighAvailableLevel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerContext
extends ReliableContainerContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerContext.class);
    private List<IEvent> reliableEvents = new ArrayList<IEvent>();
    private transient List<IEvent> waitingCheckpointEvents = new ArrayList<IEvent>();

    public ContainerContext(int id, Configuration config) {
        super(id, config);
    }

    public ContainerContext(int id, Configuration config, boolean isRecover) {
        this(id, config);
        this.isRecover = isRecover;
    }

    public ContainerContext(int id, Configuration config, boolean isRecover, List<IEvent> reliableEvents) {
        this(id, config, isRecover);
        this.reliableEvents = reliableEvents;
    }

    @Override
    public void load() {
        if (this.isRecover()) {
            List<IEvent> events = ClusterMetaStore.getInstance(this.id, this.config).getEvents();
            if (events == null) {
                LOGGER.info("container {} not found any events to recover", (Object)this.id);
            } else {
                LOGGER.info("container {} recover events {}", (Object)this.id, events);
                this.reliableEvents = events;
            }
        }
        if (this.waitingCheckpointEvents == null) {
            this.waitingCheckpointEvents = new ArrayList<IEvent>();
        } else {
            this.waitingCheckpointEvents.clear();
        }
    }

    public static ContainerContext build(int id, Configuration config, boolean isRecover) {
        List<IEvent> events = ClusterMetaStore.getInstance(id, config).getEvents();
        if (events == null) {
            LOGGER.info("container {} not found any events to recover", (Object)id);
            return new ContainerContext(id, config, isRecover);
        }
        LOGGER.info("container {} recover events {}", (Object)id, events);
        ContainerContext context = new ContainerContext(id, config, true, events);
        return context;
    }

    public List<IEvent> getReliableEvents() {
        return this.reliableEvents;
    }

    public synchronized void addEvent(IEvent input) {
        if (input instanceof IHighAvailableEvent) {
            if (((IHighAvailableEvent)((Object)input)).getHaLevel() == HighAvailableLevel.CHECKPOINT) {
                if (this.waitingCheckpointEvents == null) {
                    this.waitingCheckpointEvents = new ArrayList<IEvent>();
                }
                if (!this.waitingCheckpointEvents.contains(input)) {
                    this.waitingCheckpointEvents.add(input);
                    LOGGER.info("container {} add recoverable event {}", (Object)this.id, (Object)input);
                } else {
                    LOGGER.info("container {} already has recoverable event {}", (Object)this.id, (Object)input);
                }
            }
        } else if (input.getEventType() == EventType.COMPOSE) {
            IComposeEvent composeEvent = (IComposeEvent)input;
            for (IEvent event : composeEvent.getEventList()) {
                this.addEvent(event);
            }
        }
    }

    public static class EventCheckpointFunction
    implements IReliableContext.IReliableContextCheckpointFunction {
        @Override
        public void doCheckpoint(IReliableContext context) {
            ContainerContext containerContext = (ContainerContext)context;
            if (containerContext.waitingCheckpointEvents == null || containerContext.waitingCheckpointEvents.isEmpty()) {
                LOGGER.info("container {} has no new events to checkpoint", (Object)containerContext.getId());
                return;
            }
            List reliableEvents = ClusterMetaStore.getInstance().getEvents();
            if (reliableEvents == null) {
                reliableEvents = containerContext.waitingCheckpointEvents;
            } else {
                for (IEvent event : containerContext.waitingCheckpointEvents) {
                    if (reliableEvents.contains(event)) {
                        LOGGER.info("container {} already has saved recoverable event {}", (Object)containerContext.id, (Object)event);
                        continue;
                    }
                    reliableEvents.add(event);
                }
            }
            ClusterMetaStore.getInstance().saveEvent(reliableEvents).flush();
            LOGGER.info("container {} checkpoint events {}", (Object)containerContext.getId(), (Object)reliableEvents);
            containerContext.waitingCheckpointEvents.clear();
        }
    }
}

