/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.driver;

import com.antgroup.geaflow.cluster.common.IReliableContext;
import com.antgroup.geaflow.cluster.common.ReliableContainerContext;
import com.antgroup.geaflow.cluster.driver.Driver;
import com.antgroup.geaflow.cluster.system.ClusterMetaStore;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.pipeline.Pipeline;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverContext
extends ReliableContainerContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(Driver.class);
    private Pipeline pipeline;
    private List<Integer> finishedPipelineTasks;

    public DriverContext(int index, Configuration config) {
        super(index, config);
        this.finishedPipelineTasks = new ArrayList<Integer>();
    }

    public DriverContext(int index, Configuration config, boolean isRecover) {
        super(index, config);
        this.isRecover = isRecover;
        this.finishedPipelineTasks = new ArrayList<Integer>();
    }

    @Override
    public void load() {
        Pipeline pipeline = ClusterMetaStore.getInstance(this.id, this.config).getPipeline();
        if (pipeline != null) {
            List<Integer> finishedPipelineTasks = ClusterMetaStore.getInstance().getPipelineTasks();
            if (finishedPipelineTasks == null) {
                finishedPipelineTasks = new ArrayList<Integer>();
            }
            this.pipeline = pipeline;
            this.finishedPipelineTasks = finishedPipelineTasks;
            LOGGER.info("driver {} recover context {}", (Object)this.id, (Object)this);
        }
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void addPipeline(Pipeline pipeline) {
        if (!pipeline.equals(this.pipeline)) {
            this.pipeline = pipeline;
        }
    }

    public List<Integer> getFinishedPipelineTasks() {
        return this.finishedPipelineTasks;
    }

    public void addFinishedPipelineTask(int pipelineTaskIndex) {
        if (!this.finishedPipelineTasks.contains(pipelineTaskIndex)) {
            this.finishedPipelineTasks.add(pipelineTaskIndex);
        }
    }

    public static class PipelineTaskCheckpointFunction
    implements IReliableContext.IReliableContextCheckpointFunction {
        @Override
        public void doCheckpoint(IReliableContext context) {
            DriverContext driverContext = (DriverContext)context;
            if (driverContext.getFinishedPipelineTasks() != null && !driverContext.getFinishedPipelineTasks().isEmpty()) {
                ClusterMetaStore.getInstance().savePipelineTasks(driverContext.getFinishedPipelineTasks()).flush();
                LOGGER.info("driver {} checkpoint pipeline finished tasks {}", (Object)driverContext.getId(), driverContext.getFinishedPipelineTasks());
            }
        }
    }

    public static class PipelineCheckpointFunction
    implements IReliableContext.IReliableContextCheckpointFunction {
        @Override
        public void doCheckpoint(IReliableContext context) {
            DriverContext driverContext = (DriverContext)context;
            if (driverContext.getPipeline() != null) {
                ClusterMetaStore.getInstance().savePipeline(driverContext.getPipeline()).flush();
                LOGGER.info("driver {} checkpoint pipeline", (Object)driverContext.getId());
            }
        }
    }
}

