/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.exception;

import com.antgroup.geaflow.cluster.exception.ExceptionClient;
import com.antgroup.geaflow.cluster.task.runner.AbstractTaskRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentExceptionSupervisor
extends AbstractTaskRunner<ExceptionElement> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentExceptionSupervisor.class);
    private static ComponentExceptionSupervisor INSTANCE;

    @Override
    protected void process(ExceptionElement exceptionElement) {
        LOGGER.error(String.format("%s occur fatal exception, exit process now", exceptionElement.thread), exceptionElement.cause);
        ExceptionClient exceptionClient = ExceptionClient.getInstance();
        if (exceptionClient != null) {
            exceptionClient.sendException(exceptionElement.cause);
        }
        if (this.running) {
            System.exit(1);
        } else {
            LOGGER.info("{} ignore exception because supervisor is shutdown", (Object)exceptionElement.thread);
        }
    }

    public static synchronized ComponentExceptionSupervisor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ComponentExceptionSupervisor();
        }
        return INSTANCE;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        INSTANCE = null;
    }

    public static class ExceptionElement {
        private Thread thread;
        private Throwable cause;

        public ExceptionElement(Thread thread, Throwable cause) {
            this.thread = thread;
            this.cause = cause;
        }

        public static ExceptionElement of(Thread thread, Throwable cause) {
            return new ExceptionElement(thread, cause);
        }
    }
}

