/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.exception;

import com.antgroup.geaflow.cluster.exception.ComponentExceptionSupervisor;
import com.antgroup.geaflow.stats.collector.StatsCollectorFactory;
import com.antgroup.geaflow.stats.model.ExceptionLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentUncaughtExceptionHandler.class);

    @Override
    public void uncaughtException(Thread thread, Throwable cause) {
        LOGGER.error("FATAL exception in thread:{}", (Object)thread.getName(), (Object)cause);
        StatsCollectorFactory collectorFactory = StatsCollectorFactory.getInstance();
        if (collectorFactory != null) {
            collectorFactory.getExceptionCollector().reportException(ExceptionLevel.FATAL, cause);
        }
        ComponentExceptionSupervisor.getInstance().add(ComponentExceptionSupervisor.ExceptionElement.of(thread, cause));
    }
}

