/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.exception;

import com.antgroup.geaflow.cluster.rpc.RpcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionClient.class);
    private static ExceptionClient INSTANCE;
    private final int containerId;
    private final String masterId;

    public ExceptionClient(int containerId, String masterId) {
        this.containerId = containerId;
        this.masterId = masterId;
    }

    public static synchronized ExceptionClient init(int containerId, String masterId) {
        if (INSTANCE == null) {
            INSTANCE = new ExceptionClient(containerId, masterId);
        }
        return INSTANCE;
    }

    public static synchronized ExceptionClient getInstance() {
        return INSTANCE;
    }

    public void sendException(Throwable throwable) {
        try {
            LOGGER.info("Send exception {} to master.", (Object)throwable.getMessage());
            RpcClient.getInstance().sendException(this.masterId, this.containerId, throwable);
        }
        catch (Throwable e) {
            LOGGER.error("Send exception {} to master failed.", (Object)throwable.getMessage(), (Object)e);
        }
    }
}

