/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.executor;

import com.antgroup.geaflow.cluster.executor.IPipelineExecutor;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineExecutorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineExecutorFactory.class);

    public static IPipelineExecutor createPipelineExecutor() {
        ServiceLoader<IPipelineExecutor> executorLoader = ServiceLoader.load(IPipelineExecutor.class);
        Iterator<IPipelineExecutor> executorIterable = executorLoader.iterator();
        if (executorIterable.hasNext()) {
            return executorIterable.next();
        }
        LOGGER.error("NOT found IPipelineExecutor implementation");
        throw new GeaflowRuntimeException(RuntimeErrors.INST.spiNotFoundError(IPipelineExecutor.class.getSimpleName()));
    }
}

