/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.failover;

import com.antgroup.geaflow.cluster.failover.IFailoverStrategy;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.env.IEnvironment;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoStrategyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FoStrategyFactory.class);

    public static IFailoverStrategy loadFoStrategy(IEnvironment.EnvType envType, String foStrategyType) {
        ServiceLoader<IFailoverStrategy> contextLoader = ServiceLoader.load(IFailoverStrategy.class);
        for (IFailoverStrategy strategy : contextLoader) {
            if (strategy.getEnv() != envType || !strategy.getType().name().equalsIgnoreCase(foStrategyType)) continue;
            return strategy;
        }
        LOGGER.error("NOT found IFoStrategy implementation with type:{}", (Object)foStrategyType);
        throw new GeaflowRuntimeException(RuntimeErrors.INST.spiNotFoundError(IFailoverStrategy.class.getSimpleName()));
    }
}

