/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.fetcher;

import com.antgroup.geaflow.cluster.fetcher.FetcherRunner;
import com.antgroup.geaflow.cluster.fetcher.IFetchRequest;
import com.antgroup.geaflow.cluster.task.service.AbstractTaskService;
import com.antgroup.geaflow.common.config.Configuration;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetcherService
extends AbstractTaskService<IFetchRequest, FetcherRunner>
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetcherService.class);
    private static final String FETCHER_FORMAT = "geaflow-fetcher-%d";
    private int slots;
    private Configuration configuration;

    public FetcherService(int slots, Configuration configuration) {
        super(FETCHER_FORMAT);
        this.slots = slots;
        this.configuration = configuration;
    }

    protected FetcherRunner[] buildTaskRunner() {
        Preconditions.checkArgument((this.slots > 0 ? 1 : 0) != 0, (Object)"fetcher pool should be larger than 0");
        FetcherRunner[] fetcherRunners = new FetcherRunner[this.slots];
        for (int i = 0; i < this.slots; ++i) {
            FetcherRunner runner;
            fetcherRunners[i] = runner = new FetcherRunner(this.configuration);
        }
        return fetcherRunners;
    }
}

