/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.fetcher;

import com.antgroup.geaflow.cluster.fetcher.IFetchRequest;
import com.antgroup.geaflow.cluster.fetcher.IInputMessageBuffer;
import com.antgroup.geaflow.cluster.shuffle.LogicalPipelineSliceMeta;
import com.antgroup.geaflow.common.encoder.IEncoder;
import com.antgroup.geaflow.common.shuffle.ShuffleDescriptor;
import com.antgroup.geaflow.shuffle.message.ISliceMeta;
import com.antgroup.geaflow.shuffle.message.Shard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InitFetchRequest
implements IFetchRequest {
    private final long pipelineId;
    private final String pipelineName;
    private int taskId;
    private int taskIndex;
    private String taskName;
    private int vertexId;
    private ShuffleDescriptor descriptor;
    private List<IInputMessageBuffer<?>> fetchListeners;
    private Map<Integer, String> inputStreamMap;
    private Map<Integer, List<ISliceMeta>> inputSlices;
    private Map<Integer, IEncoder<?>> encoders;
    private int totalSliceNum;

    public InitFetchRequest(long pipelineId, String pipelineName) {
        this.pipelineId = pipelineId;
        this.pipelineName = pipelineName;
        this.fetchListeners = new ArrayList();
    }

    public long getPipelineId() {
        return this.pipelineId;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public int getTaskIndex() {
        return this.taskIndex;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getVertexId() {
        return this.vertexId;
    }

    public Map<Integer, String> getInputStreamMap() {
        return this.inputStreamMap;
    }

    public ShuffleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public List<IInputMessageBuffer<?>> getFetchListeners() {
        return this.fetchListeners;
    }

    public Map<Integer, List<ISliceMeta>> getInputSlices() {
        return this.inputSlices;
    }

    public int getTotalSliceNum() {
        return this.totalSliceNum;
    }

    public void addListener(IInputMessageBuffer<?> listener) {
        this.fetchListeners.add(listener);
    }

    public InitFetchRequest setTaskId(int taskId) {
        this.taskId = taskId;
        return this;
    }

    public InitFetchRequest setTaskIndex(int taskIndex) {
        this.taskIndex = taskIndex;
        return this;
    }

    public InitFetchRequest setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    public InitFetchRequest setVertexId(int vertexId) {
        this.vertexId = vertexId;
        return this;
    }

    public InitFetchRequest setDescriptor(ShuffleDescriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    public InitFetchRequest setInputStreamMap(Map<Integer, String> inputStreamMap) {
        this.inputStreamMap = inputStreamMap;
        return this;
    }

    public void setInputShardMap(Map<Integer, List<Shard>> inputShardMap) {
        if (inputShardMap != null) {
            this.inputSlices = new HashMap<Integer, List<ISliceMeta>>();
            for (Map.Entry<Integer, List<Shard>> entry : inputShardMap.entrySet()) {
                ArrayList<Object> slices = new ArrayList<Object>();
                for (Shard shard : entry.getValue()) {
                    for (ISliceMeta sliceMeta : shard.getSlices()) {
                        if (sliceMeta instanceof LogicalPipelineSliceMeta) {
                            LogicalPipelineSliceMeta logicalPipelineSliceMeta = (LogicalPipelineSliceMeta)sliceMeta;
                            slices.add(logicalPipelineSliceMeta.toPhysicalPipelineSliceMeta());
                            continue;
                        }
                        slices.add(sliceMeta);
                    }
                }
                this.inputSlices.put(entry.getKey(), slices);
                this.totalSliceNum += slices.size();
            }
        }
    }

    public Map<Integer, IEncoder<?>> getEncoders() {
        return this.encoders;
    }

    public InitFetchRequest setEncoders(Map<Integer, IEncoder<?>> encoders) {
        this.encoders = encoders;
        return this;
    }

    public static class InitRequestBuilder {
        private long pipelineId;
        private String pipelineName;

        public InitRequestBuilder(long pipelineId, String pipelineName) {
            this.pipelineId = pipelineId;
            this.pipelineName = pipelineName;
        }

        public InitFetchRequest setInputShardMap(Map<Integer, List<Shard>> inputShardMap) {
            InitFetchRequest request = new InitFetchRequest(this.pipelineId, this.pipelineName);
            request.setInputShardMap(inputShardMap);
            return request;
        }
    }
}

