/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.heartbeat;

import com.antgroup.geaflow.cluster.heartbeat.HeartbeatSender;
import com.antgroup.geaflow.cluster.rpc.RpcClient;
import com.antgroup.geaflow.cluster.rpc.RpcEndpointRef;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.heartbeat.Heartbeat;
import com.antgroup.geaflow.rpc.proto.Master;
import com.antgroup.geaflow.stats.collector.ProcessStatsCollector;
import com.antgroup.geaflow.stats.collector.StatsCollectorFactory;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatClient
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatClient.class);
    private final int containerId;
    private final String containerName;
    private final Configuration config;
    private HeartbeatSender heartbeatSender;
    private final ProcessStatsCollector statsCollector;
    private String masterId;

    public HeartbeatClient(int containerId, String containerName, Configuration config) {
        this.containerId = containerId;
        this.containerName = containerName;
        this.config = config;
        this.statsCollector = StatsCollectorFactory.getInstance().getProcessStatsCollector();
    }

    public <T> void registerToMaster(String masterId, T info) {
        this.masterId = masterId;
        LOGGER.info("register {} info:{}", (Object)this.containerName, info);
        RpcClient.init(this.config);
        this.doRegister(masterId, info);
    }

    private <T> void doRegister(final String masterId, T info) {
        RpcClient.getInstance().registerContainer(masterId, info, new RpcEndpointRef.RpcCallback<Master.RegisterResponse>(){

            @Override
            public void onSuccess(Master.RegisterResponse event) {
                LOGGER.info("{} registered success:{}", (Object)HeartbeatClient.this.containerName, (Object)event.getSuccess());
                HeartbeatClient.this.startHeartBeat(masterId);
            }

            @Override
            public void onFailure(Throwable t) {
                LOGGER.error("register info failed", t);
            }
        });
    }

    public void startHeartBeat(String masterId) {
        LOGGER.info("start {} heartbeat", (Object)this.containerName);
        this.heartbeatSender = new HeartbeatSender(masterId, () -> {
            Heartbeat heartbeat = null;
            if (this.containerName != null) {
                heartbeat = new Heartbeat(this.containerId);
                heartbeat.setProcessMetrics(this.statsCollector.collect());
            }
            return heartbeat;
        }, this.config);
        this.heartbeatSender.start();
    }

    public void close() {
        if (this.heartbeatSender != null) {
            this.heartbeatSender.close();
        }
    }
}

