/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.heartbeat;

import com.antgroup.geaflow.cluster.rpc.RpcClient;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.heartbeat.Heartbeat;
import com.antgroup.geaflow.common.utils.ExecutorUtil;
import com.antgroup.geaflow.common.utils.ThreadUtil;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatSender
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatSender.class);
    private final String masterId;
    private final ScheduledExecutorService scheduledService;
    private final Supplier<Heartbeat> heartbeatTrigger;
    private final long initialDelayMs;
    private final long intervalMs;

    public HeartbeatSender(String masterId, Supplier<Heartbeat> heartbeatTrigger, Configuration config) {
        this.masterId = masterId;
        this.heartbeatTrigger = heartbeatTrigger;
        this.scheduledService = new ScheduledThreadPoolExecutor(1, ThreadUtil.namedThreadFactory((boolean)true, (String)"heartbeat-sender"));
        this.initialDelayMs = config.getInteger(ExecutionConfigKeys.HEARTBEAT_INITIAL_DELAY_MS);
        this.intervalMs = config.getInteger(ExecutionConfigKeys.HEARTBEAT_INTERVAL_MS);
    }

    public void start() {
        this.scheduledService.scheduleWithFixedDelay(() -> {
            Heartbeat message = null;
            try {
                message = this.heartbeatTrigger.get();
                if (message != null) {
                    RpcClient.getInstance().sendHeartBeat(this.masterId, message);
                }
            }
            catch (Throwable e) {
                LOGGER.error("send heartbeat {} failed", (Object)message, (Object)e);
            }
        }, this.initialDelayMs, this.intervalMs, TimeUnit.MILLISECONDS);
    }

    public void close() {
        if (this.scheduledService != null) {
            LOGGER.info("shutdown heartbeat sender thread pool");
            ExecutorUtil.shutdown((ExecutorService)this.scheduledService);
        }
    }
}

