/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.master;

import com.antgroup.geaflow.cluster.clustermanager.ClusterContext;
import com.antgroup.geaflow.cluster.clustermanager.ClusterInfo;
import com.antgroup.geaflow.cluster.clustermanager.IClusterManager;
import com.antgroup.geaflow.cluster.common.AbstractComponent;
import com.antgroup.geaflow.cluster.heartbeat.HeartbeatManager;
import com.antgroup.geaflow.cluster.master.IMaster;
import com.antgroup.geaflow.cluster.master.MasterContext;
import com.antgroup.geaflow.cluster.resourcemanager.IResourceManager;
import com.antgroup.geaflow.cluster.resourcemanager.ResourceManagerContext;
import com.antgroup.geaflow.cluster.resourcemanager.ResourceManagerFactory;
import com.antgroup.geaflow.cluster.rpc.RpcAddress;
import com.antgroup.geaflow.cluster.rpc.impl.MasterEndpoint;
import com.antgroup.geaflow.cluster.rpc.impl.ResourceManagerEndpoint;
import com.antgroup.geaflow.cluster.rpc.impl.RpcServiceImpl;
import com.antgroup.geaflow.cluster.web.HttpServer;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.utils.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Master
extends AbstractComponent
implements IMaster {
    private static final Logger LOGGER = LoggerFactory.getLogger(Master.class);
    private IResourceManager resourceManager;
    private IClusterManager clusterManager;
    private HeartbeatManager heartbeatManager;
    private RpcAddress masterAddress;
    private HttpServer httpServer;

    public Master() {
        this(0);
    }

    public Master(int rpcPort) {
        super(rpcPort);
    }

    @Override
    public void init(MasterContext context) {
        super.init(0, context.getConfiguration().getMasterId(), context.getConfiguration());
        this.clusterManager = context.getClusterManager();
        this.resourceManager = ResourceManagerFactory.build(context);
        this.startRpcService();
        this.masterAddress = new RpcAddress(ProcessUtil.getHostIp(), this.rpcPort);
        this.heartbeatManager = new HeartbeatManager(this.configuration, this.clusterManager);
        this.registerHAService();
        ClusterContext clusterContext = new ClusterContext(this.configuration);
        clusterContext.setHeartbeatManager(this.heartbeatManager);
        this.clusterManager.init(clusterContext);
        this.resourceManager.init(ResourceManagerContext.build(context, clusterContext));
        this.masterAddress = new RpcAddress(ProcessUtil.getHostIp(), this.rpcPort);
        if (!context.getConfiguration().getBoolean(ExecutionConfigKeys.RUN_LOCAL_MODE)) {
            this.httpServer = new HttpServer(this.configuration, this.clusterManager, this.heartbeatManager);
            this.httpServer.start();
        }
    }

    @Override
    protected void startRpcService() {
        this.rpcService = new RpcServiceImpl(this.rpcPort, this.configuration);
        this.rpcService.addEndpoint(new MasterEndpoint(this, this.clusterManager));
        this.rpcService.addEndpoint(new ResourceManagerEndpoint(this.resourceManager));
        this.rpcPort = this.rpcService.startService();
    }

    public ClusterInfo startCluster() {
        RpcAddress driverAddress = this.clusterManager.startDriver();
        ClusterInfo clusterInfo = new ClusterInfo();
        clusterInfo.setMasterAddress(this.masterAddress);
        clusterInfo.setDriverAddress(driverAddress);
        LOGGER.info("init with info: {}", (Object)clusterInfo);
        return clusterInfo;
    }

    @Override
    public void close() {
        super.close();
        this.clusterManager.close();
        if (this.heartbeatManager != null) {
            this.heartbeatManager.close();
        }
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        LOGGER.info("master {} closed", (Object)this.name);
    }
}

