/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.resourcemanager;

import com.antgroup.geaflow.cluster.clustermanager.AbstractClusterManager;
import com.antgroup.geaflow.cluster.clustermanager.IClusterManager;
import com.antgroup.geaflow.cluster.resourcemanager.DefaultResourceManager;
import com.antgroup.geaflow.cluster.resourcemanager.ResourceManagerContext;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesResourceManager
extends DefaultResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesResourceManager.class);
    private static final String LABEL_CONTAINER_INDEX_PATTERN = "container-index-%s";
    private static final int MASTER_COMPONENT_ID = 0;

    public KubernetesResourceManager(IClusterManager clusterManager) {
        super(clusterManager);
    }

    @Override
    public void init(ResourceManagerContext context) {
        String clusterId = context.getConfig().getString(ExecutionConfigKeys.CLUSTER_ID);
        String containerIndexLabel = String.format(LABEL_CONTAINER_INDEX_PATTERN, clusterId);
        Set<Integer> containerIndex = this.metaKeeper.getComponentIds(containerIndexLabel);
        LOGGER.info("get container index {} of label {} from backend", containerIndex, (Object)containerIndexLabel);
        boolean isRecover = containerIndex != null;
        context.setRecover(isRecover);
        super.init(context);
        if (isRecover) {
            LOGGER.info("recover container index {} of label {} from backend", containerIndex, (Object)containerIndexLabel);
            ((AbstractClusterManager)this.clusterManager).setContainerIds(containerIndex);
            ((AbstractClusterManager)this.clusterManager).clusterFailover(0);
        } else {
            containerIndex = ((AbstractClusterManager)this.clusterManager).getContainerIds();
            this.metaKeeper.saveComponentIndex(containerIndexLabel, containerIndex);
            LOGGER.info("saved container index {} of label {} to backend", containerIndex, (Object)containerIndexLabel);
        }
    }
}

