/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.resourcemanager;

import java.io.Serializable;
import java.util.Objects;

public class WorkerInfo
implements Comparable<WorkerInfo>,
Serializable {
    private String host;
    private int rpcPort;
    private int shufflePort;
    private int processId;
    private int workerIndex;
    private String containerName;

    public WorkerInfo() {
    }

    public WorkerInfo(String host, int rpcPort, int shufflePort, int processId, int workerId, String containerName) {
        this.host = host;
        this.rpcPort = rpcPort;
        this.shufflePort = shufflePort;
        this.processId = processId;
        this.workerIndex = workerId;
        this.containerName = containerName;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public int getShufflePort() {
        return this.shufflePort;
    }

    public void setShufflePort(int shufflePort) {
        this.shufflePort = shufflePort;
    }

    public int getWorkerIndex() {
        return this.workerIndex;
    }

    public void setWorkerIndex(int workerIndex) {
        this.workerIndex = workerIndex;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public WorkerId generateWorkerId() {
        return new WorkerId(this.containerName, this.workerIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerInfo that = (WorkerInfo)o;
        return Objects.equals(this.containerName, that.containerName) && this.processId == that.processId && this.workerIndex == that.workerIndex;
    }

    public int hashCode() {
        return Objects.hash(this.containerName, this.processId, this.workerIndex);
    }

    @Override
    public int compareTo(WorkerInfo o) {
        int flag = this.containerName.compareTo(o.containerName);
        if (flag == 0 && (flag = Integer.compare(this.processId, o.processId)) == 0) {
            flag = Integer.compare(this.workerIndex, o.workerIndex);
        }
        return flag;
    }

    public String toString() {
        return "WorkerInfo{host='" + this.host + '\'' + ", rpcPort=" + this.rpcPort + ", shufflePort=" + this.shufflePort + ", processId=" + this.processId + ", workerIndex=" + this.workerIndex + ", containerName='" + this.containerName + '\'' + '}';
    }

    public static WorkerInfo build(String host, int rpcPort, int shufflePort, int processId, int workerId, String containerName) {
        return new WorkerInfo(host, rpcPort, shufflePort, processId, workerId, containerName);
    }

    public static class WorkerId {
        private final String containerName;
        private final int workerIndex;

        public WorkerId(String containerName, int workerIndex) {
            this.containerName = containerName;
            this.workerIndex = workerIndex;
        }

        public String getContainerName() {
            return this.containerName;
        }

        public int getWorkerIndex() {
            return this.workerIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkerId workerId = (WorkerId)o;
            return Objects.equals(this.containerName, workerId.containerName) && this.workerIndex == workerId.workerIndex;
        }

        public int hashCode() {
            return Objects.hash(this.containerName, this.workerIndex);
        }

        public String toString() {
            return this.containerName + '/' + this.workerIndex;
        }
    }
}

