/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.resourcemanager.allocator;

import com.antgroup.geaflow.cluster.resourcemanager.WorkerInfo;
import com.antgroup.geaflow.cluster.resourcemanager.allocator.IAllocator;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAllocator<G, W>
implements IAllocator<G, W> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAllocator.class);
    protected static final IAllocator.WorkerGroupByFunction<String, WorkerInfo> PROC_GROUP_SELECTOR = worker -> String.format("%s-%d", worker.getHost(), worker.getProcessId());
    protected Map<Comparable<G>, LinkedList<W>> group2workers = new TreeMap<Comparable<G>, LinkedList<W>>();

    protected AbstractAllocator() {
    }

    @Override
    public List<W> allocate(Collection<W> idleWorkers, int num) {
        if (idleWorkers.size() < num) {
            LOGGER.warn("worker not enough, available {} require {}", (Object)idleWorkers.size(), (Object)num);
            return Collections.emptyList();
        }
        IAllocator.WorkerGroupByFunction groupSelector = this.getWorkerGroupByFunction();
        for (W worker : idleWorkers) {
            Comparable group = groupSelector.getGroup(worker);
            List list = this.group2workers.computeIfAbsent(group, g -> new LinkedList());
            list.add(worker);
        }
        List<W> allocated = this.doAllocate(num);
        this.reset();
        return allocated;
    }

    protected abstract List<W> doAllocate(int var1);

    private void reset() {
        this.group2workers.clear();
    }
}

