/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.response;

import com.antgroup.geaflow.cluster.response.IResult;
import com.antgroup.geaflow.io.CollectType;
import com.antgroup.geaflow.shuffle.message.ISliceMeta;
import java.util.List;

public class ShardResult
implements IResult<ISliceMeta> {
    private int id;
    private CollectType outputType;
    private List<ISliceMeta> slices;
    private long recordNum;
    private long recordBytes;

    public ShardResult(int id, CollectType outputType, List<ISliceMeta> slices) {
        this.id = id;
        this.outputType = outputType;
        this.slices = slices;
        if (slices != null) {
            for (ISliceMeta sliceMeta : slices) {
                this.recordNum += sliceMeta.getRecordNum();
                this.recordBytes += sliceMeta.getEncodedSize();
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public List<ISliceMeta> getResponse() {
        return this.slices;
    }

    public long getRecordNum() {
        return this.recordNum;
    }

    public long getRecordBytes() {
        return this.recordBytes;
    }

    @Override
    public CollectType getType() {
        return this.outputType;
    }
}

