/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.rpc;

import java.io.Serializable;
import java.util.Objects;

public class RpcAddress
implements Serializable {
    private String host;
    private int port;

    public RpcAddress() {
    }

    public RpcAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RpcAddress that = (RpcAddress)o;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String getAddress() {
        return this.host + ":" + this.port;
    }

    public String toString() {
        return "RpcAddress{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }

    public static RpcAddress build(String address) {
        RpcAddress rpcAddress = new RpcAddress();
        String[] hostAndPort = address.split(":");
        rpcAddress.setHost(hostAndPort[0]);
        rpcAddress.setPort(Integer.parseInt(hostAndPort[1]));
        return rpcAddress;
    }
}

