/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.rpc;

import com.antgroup.geaflow.cluster.protocol.IEvent;
import com.antgroup.geaflow.cluster.rpc.impl.RpcMessageEncoder;
import com.antgroup.geaflow.rpc.proto.Container;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class RpcResponseFuture
implements Future<IEvent> {
    private final ListenableFuture<Container.Response> delegate;

    public RpcResponseFuture(ListenableFuture<Container.Response> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public IEvent get() throws InterruptedException, ExecutionException {
        Container.Response response = (Container.Response)this.delegate.get();
        return this.getEvent(response);
    }

    @Override
    public IEvent get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Container.Response response = (Container.Response)this.delegate.get(timeout, unit);
        return this.getEvent(response);
    }

    private IEvent getEvent(Container.Response response) {
        ByteString payload = response.getPayload();
        if (payload == null || payload == ByteString.EMPTY) {
            return null;
        }
        return (IEvent)RpcMessageEncoder.decode(payload);
    }
}

