/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.rpc.impl;

import com.antgroup.geaflow.cluster.rpc.RpcEndpointRef;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.ManagedChannel;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.ChannelOption;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRpcEndpointRef
implements RpcEndpointRef {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRpcEndpointRef.class);
    private static final int DEFAULT_TIMEOUT_MS = 30000;
    private static final int DEFAULT_MAX_RETRY_TIMES = 10;
    protected final String host;
    protected final int port;
    protected final int timeoutMs;
    protected final ExecutorService executorService;
    protected ManagedChannel channel;

    public AbstractRpcEndpointRef(String host, int port, ExecutorService executorService) {
        this.host = host;
        this.port = port;
        this.timeoutMs = 30000;
        this.channel = this.buildChannel(host, port, this.timeoutMs);
        this.executorService = executorService;
        this.createStub(this.channel);
    }

    protected ManagedChannel buildChannel(String host, int port, int timeoutMs) {
        return ((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)host, (int)port).withOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeoutMs).enableRetry()).maxRetryAttempts(10)).usePlaintext().build();
    }

    protected synchronized void ensureChannelAlive() {
        if (this.channel.isShutdown() || this.channel.isTerminated()) {
            this.channel = this.buildChannel(this.host, this.port, this.timeoutMs);
            this.createStub(this.channel);
        }
    }

    protected abstract void createStub(ManagedChannel var1);

    protected <T> void handleFutureCallback(ListenableFuture<T> future, final RpcEndpointRef.RpcCallback<T> listener) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(@Nullable T result) {
                listener.onSuccess(result);
            }

            public void onFailure(Throwable t) {
                LOGGER.error("rpc call failed", t);
                listener.onFailure(t);
            }
        }, (Executor)this.executorService);
    }

    @Override
    public void close() {
        try {
            this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("close is interrupted:{}", (Object)e.getMessage());
        }
    }
}

