/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.rpc.impl;

import com.antgroup.geaflow.cluster.container.Container;
import com.antgroup.geaflow.cluster.protocol.IEvent;
import com.antgroup.geaflow.cluster.protocol.OpenContainerEvent;
import com.antgroup.geaflow.cluster.rpc.RpcEndpoint;
import com.antgroup.geaflow.cluster.rpc.impl.RpcMessageEncoder;
import com.antgroup.geaflow.rpc.proto.Container;
import com.antgroup.geaflow.rpc.proto.ContainerServiceGrpc;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerEndpoint
extends ContainerServiceGrpc.ContainerServiceImplBase
implements RpcEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerEndpoint.class);
    private final Container container;

    public ContainerEndpoint(Container workerContainer) {
        this.container = workerContainer;
    }

    public void process(Container.Request request, StreamObserver<Container.Response> responseObserver) {
        try {
            IEvent event = (IEvent)RpcMessageEncoder.decode(request.getPayload());
            IEvent res = event instanceof OpenContainerEvent ? this.container.open((OpenContainerEvent)event) : this.container.process(event);
            Container.Response.Builder builder = Container.Response.newBuilder();
            if (res != null) {
                ByteString payload = RpcMessageEncoder.encode(res);
                builder.setPayload(payload);
            }
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }
        catch (Throwable t) {
            LOGGER.error("process request failed: {}", (Object)t.getMessage(), (Object)t);
            responseObserver.onError(t);
        }
    }

    public void close(Empty request, StreamObserver<Empty> responseObserver) {
        try {
            this.container.close();
            responseObserver.onNext((Object)Empty.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (Throwable t) {
            LOGGER.error("close failed: {}", (Object)t.getMessage(), (Object)t);
            responseObserver.onError(t);
        }
    }
}

