/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.rpc.impl;

import com.antgroup.geaflow.cluster.protocol.IEvent;
import com.antgroup.geaflow.cluster.rpc.IContainerEndpointRef;
import com.antgroup.geaflow.cluster.rpc.RpcEndpointRef;
import com.antgroup.geaflow.cluster.rpc.RpcResponseFuture;
import com.antgroup.geaflow.cluster.rpc.impl.AbstractRpcEndpointRef;
import com.antgroup.geaflow.cluster.rpc.impl.RpcMessageEncoder;
import com.antgroup.geaflow.rpc.proto.Container;
import com.antgroup.geaflow.rpc.proto.ContainerServiceGrpc;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ContainerEndpointRef
extends AbstractRpcEndpointRef
implements IContainerEndpointRef {
    protected ContainerServiceGrpc.ContainerServiceFutureStub stub;
    protected ContainerServiceGrpc.ContainerServiceBlockingStub blockingStub;

    public ContainerEndpointRef(String host, int port, ExecutorService executorService) {
        super(host, port, executorService);
    }

    @Override
    protected void createStub(ManagedChannel channel) {
        this.stub = ContainerServiceGrpc.newFutureStub((Channel)channel);
        this.blockingStub = ContainerServiceGrpc.newBlockingStub((Channel)channel);
    }

    @Override
    public Future<IEvent> process(IEvent request) {
        this.ensureChannelAlive();
        Container.Request req = this.buildRequest(request);
        ListenableFuture future = this.stub.process(req);
        return new RpcResponseFuture((ListenableFuture<Container.Response>)future);
    }

    @Override
    public void process(IEvent request, RpcEndpointRef.RpcCallback<Container.Response> callback) {
        this.ensureChannelAlive();
        Container.Request req = this.buildRequest(request);
        ListenableFuture future = this.stub.process(req);
        this.handleFutureCallback(future, callback);
    }

    @Override
    public void close() {
        this.ensureChannelAlive();
        this.blockingStub.close(Empty.newBuilder().build());
        super.close();
    }

    protected Container.Request buildRequest(IEvent request) {
        ByteString payload = RpcMessageEncoder.encode(request);
        return Container.Request.newBuilder().setPayload(payload).build();
    }
}

