/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.rpc.impl;

import com.antgroup.geaflow.cluster.driver.IDriver;
import com.antgroup.geaflow.cluster.rpc.RpcEndpoint;
import com.antgroup.geaflow.cluster.rpc.impl.RpcMessageEncoder;
import com.antgroup.geaflow.pipeline.Pipeline;
import com.antgroup.geaflow.rpc.proto.Driver;
import com.antgroup.geaflow.rpc.proto.DriverServiceGrpc;
import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverEndpoint
extends DriverServiceGrpc.DriverServiceImplBase
implements RpcEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriverEndpoint.class);
    private final IDriver driver;

    public DriverEndpoint(IDriver driver) {
        this.driver = driver;
    }

    public void executePipeline(Driver.PipelineReq request, StreamObserver<Driver.PipelineRes> responseObserver) {
        try {
            responseObserver.onNext((Object)Driver.PipelineRes.newBuilder().build());
            Pipeline pipeline = (Pipeline)RpcMessageEncoder.decode(request.getPayload());
            Object result = this.driver.executePipeline(pipeline);
            responseObserver.onNext((Object)Driver.PipelineRes.newBuilder().setPayload(RpcMessageEncoder.encode(result)).build());
            responseObserver.onCompleted();
        }
        catch (Throwable e) {
            LOGGER.error("execute pipeline failed: {}", (Object)e.getMessage(), (Object)e);
            responseObserver.onError(e);
        }
    }

    public void close(Empty request, StreamObserver<Empty> responseObserver) {
        try {
            this.driver.close();
            responseObserver.onNext((Object)Empty.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (Throwable t) {
            LOGGER.error("close failed: {}", (Object)t.getMessage(), (Object)t);
            responseObserver.onError(t);
        }
    }
}

