/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.rpc.impl;

import com.antgroup.geaflow.cluster.clustermanager.AbstractClusterManager;
import com.antgroup.geaflow.cluster.clustermanager.IClusterManager;
import com.antgroup.geaflow.cluster.container.ContainerInfo;
import com.antgroup.geaflow.cluster.driver.DriverInfo;
import com.antgroup.geaflow.cluster.heartbeat.HeartbeatManager;
import com.antgroup.geaflow.cluster.master.Master;
import com.antgroup.geaflow.cluster.rpc.RpcEndpoint;
import com.antgroup.geaflow.cluster.rpc.impl.RpcMessageEncoder;
import com.antgroup.geaflow.common.heartbeat.Heartbeat;
import com.antgroup.geaflow.common.metric.ProcessMetrics;
import com.antgroup.geaflow.rpc.proto.Master;
import com.antgroup.geaflow.rpc.proto.MasterServiceGrpc;
import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterEndpoint
extends MasterServiceGrpc.MasterServiceImplBase
implements RpcEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(MasterEndpoint.class);
    private final Master master;
    private final IClusterManager clusterManager;

    public MasterEndpoint(Master master, IClusterManager clusterManager) {
        this.master = master;
        this.clusterManager = clusterManager;
    }

    public void registerContainer(Master.RegisterRequest request, StreamObserver<Master.RegisterResponse> responseObserver) {
        try {
            ContainerInfo containerInfo = (ContainerInfo)RpcMessageEncoder.decode(request.getPayload());
            Master.RegisterResponse response = ((AbstractClusterManager)this.clusterManager).registerContainer(containerInfo);
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (Throwable t) {
            LOGGER.error("register container failed: {}", (Object)t.getMessage(), (Object)t);
            responseObserver.onError(t);
        }
    }

    public void registerDriver(Master.RegisterRequest request, StreamObserver<Master.RegisterResponse> responseObserver) {
        try {
            DriverInfo driverInfo = (DriverInfo)RpcMessageEncoder.decode(request.getPayload());
            Master.RegisterResponse response = ((AbstractClusterManager)this.clusterManager).registerDriver(driverInfo);
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (Throwable t) {
            LOGGER.error("register driver failed: {}", (Object)t.getMessage(), (Object)t);
            responseObserver.onError(t);
        }
    }

    public void receiveHeartbeat(Master.HeartbeatRequest request, StreamObserver<Empty> responseObserver) {
        try {
            HeartbeatManager heartbeatManager = ((AbstractClusterManager)this.clusterManager).getClusterContext().getHeartbeatManager();
            Heartbeat heartbeat = new Heartbeat(request.getId());
            heartbeat.setTimestamp(request.getTimestamp());
            heartbeat.setProcessMetrics((ProcessMetrics)RpcMessageEncoder.decode(request.getPayload()));
            heartbeatManager.receivedHeartbeat(heartbeat);
            responseObserver.onNext((Object)Empty.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (Throwable t) {
            LOGGER.error("process {} heartbeat failed: {}", new Object[]{request.getId(), t.getMessage(), t});
            responseObserver.onError(t);
        }
    }

    public void receiveException(Master.HeartbeatRequest request, StreamObserver<Empty> responseObserver) {
        try {
            int containerId = request.getId();
            LOGGER.info("received exception from container/driver {}, {}", (Object)containerId, RpcMessageEncoder.decode(request.getPayload()));
            ((AbstractClusterManager)this.clusterManager).clusterFailover(containerId);
            responseObserver.onNext((Object)Empty.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (Throwable t) {
            LOGGER.error("process {} heartbeat failed: {}", new Object[]{request.getId(), t.getMessage(), t});
            responseObserver.onError(t);
        }
    }

    public void getContainerInfo(Master.ContainerIds request, StreamObserver<Master.ContainerInfos> responseObserver) {
        responseObserver.onNext((Object)Master.ContainerInfos.newBuilder().build());
        responseObserver.onCompleted();
    }

    public void getAllContainerInfos(Empty request, StreamObserver<Master.ContainerInfos> responseObserver) {
        responseObserver.onNext((Object)Master.ContainerInfos.newBuilder().build());
        responseObserver.onCompleted();
    }

    public void close(Empty request, StreamObserver<Empty> responseObserver) {
        try {
            this.master.close();
            responseObserver.onNext((Object)Empty.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (Throwable t) {
            LOGGER.error("close failed: {}", (Object)t.getMessage(), (Object)t);
            responseObserver.onError(t);
        }
    }
}

