/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.rpc.impl;

import com.antgroup.geaflow.cluster.container.ContainerInfo;
import com.antgroup.geaflow.cluster.driver.DriverInfo;
import com.antgroup.geaflow.cluster.rpc.IMasterEndpointRef;
import com.antgroup.geaflow.cluster.rpc.RpcEndpointRef;
import com.antgroup.geaflow.cluster.rpc.impl.AbstractRpcEndpointRef;
import com.antgroup.geaflow.cluster.rpc.impl.RpcMessageEncoder;
import com.antgroup.geaflow.common.heartbeat.Heartbeat;
import com.antgroup.geaflow.rpc.proto.Master;
import com.antgroup.geaflow.rpc.proto.MasterServiceGrpc;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class MasterEndpointRef
extends AbstractRpcEndpointRef
implements IMasterEndpointRef {
    private MasterServiceGrpc.MasterServiceFutureStub stub;
    private MasterServiceGrpc.MasterServiceBlockingStub blockingStub;

    public MasterEndpointRef(String host, int port, ExecutorService executorService) {
        super(host, port, executorService);
    }

    @Override
    protected void createStub(ManagedChannel channel) {
        this.stub = MasterServiceGrpc.newFutureStub((Channel)channel);
        this.blockingStub = MasterServiceGrpc.newBlockingStub((Channel)channel);
    }

    @Override
    public <T> void registerContainer(T info, RpcEndpointRef.RpcCallback<Master.RegisterResponse> listener) {
        this.ensureChannelAlive();
        ByteString payload = RpcMessageEncoder.encode(info);
        Master.RegisterRequest register = Master.RegisterRequest.newBuilder().setPayload(payload).build();
        ListenableFuture future = info instanceof DriverInfo ? this.stub.registerDriver(register) : this.stub.registerContainer(register);
        this.handleFutureCallback(future, listener);
    }

    public ListenableFuture<Empty> sendHeartBeat(Heartbeat heartbeat) {
        this.ensureChannelAlive();
        Master.HeartbeatRequest heartbeatRequest = Master.HeartbeatRequest.newBuilder().setId(heartbeat.getContainerId()).setTimestamp(heartbeat.getTimestamp()).setPayload(RpcMessageEncoder.encode(heartbeat.getProcessMetrics())).build();
        return this.stub.receiveHeartbeat(heartbeatRequest);
    }

    @Override
    public Empty sendException(Integer containerId, String message) {
        this.ensureChannelAlive();
        Master.HeartbeatRequest heartbeatRequest = Master.HeartbeatRequest.newBuilder().setId(containerId.intValue()).setPayload(RpcMessageEncoder.encode(message)).build();
        return this.blockingStub.receiveException(heartbeatRequest);
    }

    @Override
    public List<ContainerInfo> getContainerInfo(List<String> containerIds) {
        return null;
    }

    @Override
    public void close() {
        this.ensureChannelAlive();
        this.stub.close(Empty.newBuilder().build());
        super.close();
    }
}

