/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.rpc.impl;

import com.antgroup.geaflow.cluster.driver.Driver;
import com.antgroup.geaflow.cluster.protocol.IEvent;
import com.antgroup.geaflow.cluster.rpc.RpcEndpoint;
import com.antgroup.geaflow.cluster.rpc.impl.RpcMessageEncoder;
import com.antgroup.geaflow.rpc.proto.Container;
import com.antgroup.geaflow.rpc.proto.ContainerServiceGrpc;
import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineMasterEndpoint
extends ContainerServiceGrpc.ContainerServiceImplBase
implements RpcEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineMasterEndpoint.class);
    private final Driver driver;

    public PipelineMasterEndpoint(Driver driver) {
        this.driver = driver;
    }

    public void process(Container.Request request, StreamObserver<Container.Response> responseObserver) {
        try {
            IEvent event = (IEvent)RpcMessageEncoder.decode(request.getPayload());
            this.driver.process(event);
            responseObserver.onNext((Object)Container.Response.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (Throwable t) {
            LOGGER.error("process event failed: {}", (Object)t.getMessage(), (Object)t);
            responseObserver.onError(t);
        }
    }
}

