/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.rpc.impl;

import com.antgroup.geaflow.cluster.rpc.RpcEndpoint;
import com.antgroup.geaflow.cluster.rpc.RpcEndpointRefFactory;
import com.antgroup.geaflow.cluster.rpc.RpcService;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.Serializable;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServiceImpl
implements RpcService,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcServiceImpl.class);
    private int port;
    private Server server;
    private final ServerBuilder serverBuilder;

    public RpcServiceImpl(Configuration config) {
        this(0, config);
    }

    public RpcServiceImpl(int port, Configuration config) {
        this.serverBuilder = ServerBuilder.forPort((int)port);
        RpcEndpointRefFactory.getInstance(config);
    }

    public void addEndpoint(RpcEndpoint rpcEndpoint) {
        if (rpcEndpoint instanceof BindableService) {
            this.serverBuilder.addService((BindableService)rpcEndpoint);
        }
    }

    @Override
    public int startService() {
        try {
            this.server = this.serverBuilder.build().start();
            this.port = this.server.getPort();
            LOGGER.info("Server started, listening on: {}", (Object)this.port);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    LOGGER.warn("*** shutting down gRPC server since JVM is shutting down");
                    RpcServiceImpl.this.stopService();
                    LOGGER.warn("*** server shut down");
                }
            });
            return this.port;
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new GeaflowRuntimeException(t);
        }
    }

    @Override
    @Test
    public void waitTermination() {
        try {
            this.server.awaitTermination();
        }
        catch (InterruptedException e) {
            LOGGER.warn("shutdown is interrupted");
        }
    }

    @Override
    public void stopService() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }
}

