/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.shuffle;

import com.antgroup.geaflow.common.shuffle.ShuffleAddress;
import com.antgroup.geaflow.ha.service.HAServiceFactory;
import com.antgroup.geaflow.ha.service.ResourceData;
import com.antgroup.geaflow.shuffle.message.BaseSliceMeta;
import com.antgroup.geaflow.shuffle.message.PipelineSliceMeta;
import com.antgroup.geaflow.shuffle.message.SliceId;

public class LogicalPipelineSliceMeta
extends BaseSliceMeta {
    private final SliceId sliceId;
    private String containerId;

    public LogicalPipelineSliceMeta(int sourceIndex, int targetIndex, long pipelineId, int edgeId, String containerId) {
        super(sourceIndex, targetIndex);
        this.batchId = -1L;
        this.sliceId = new SliceId(pipelineId, edgeId, sourceIndex, targetIndex);
        this.containerId = containerId;
        this.setEdgeId(edgeId);
    }

    public LogicalPipelineSliceMeta(SliceId sliceId, long batchId, String containerId) {
        super(sliceId.getShardIndex(), sliceId.getSliceIndex());
        this.batchId = batchId;
        this.sliceId = sliceId;
        this.containerId = containerId;
        this.setEdgeId(sliceId.getEdgeId());
    }

    public long getBatchId() {
        return this.batchId;
    }

    public SliceId getSliceId() {
        return this.sliceId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public PipelineSliceMeta toPhysicalPipelineSliceMeta() {
        ResourceData resourceData = HAServiceFactory.getService().resolveResource(this.containerId);
        return new PipelineSliceMeta(this.sliceId, this.batchId, new ShuffleAddress(resourceData.getHost(), resourceData.getShufflePort()));
    }
}

