/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.system;

import com.antgroup.geaflow.cluster.protocol.IEvent;
import com.antgroup.geaflow.cluster.resourcemanager.WorkerSnapshot;
import com.antgroup.geaflow.cluster.system.ClusterMetaStoreFactory;
import com.antgroup.geaflow.cluster.system.IClusterMetaKVStore;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.pipeline.Pipeline;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMetaStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterMetaStore.class);
    private static final String CLUSTER_META_NAMESPACE_LABEL = "framework";
    private static final String CLUSTER_NAMESPACE_PREFIX = "cluster";
    private static final String OFFSET_NAMESPACE = "offset";
    private static ClusterMetaStore INSTANCE;
    private final int componentId;
    private final Configuration configuration;
    private IClusterMetaKVStore<String, Object> backend;
    private IClusterMetaKVStore<String, Object> offsetBackend;

    private ClusterMetaStore(int id, Configuration configuration) {
        this.componentId = id;
        this.configuration = configuration;
        String clusterId = configuration.getString(ExecutionConfigKeys.CLUSTER_ID);
        String storeKey = String.format("%s/%s/%s", CLUSTER_META_NAMESPACE_LABEL, CLUSTER_NAMESPACE_PREFIX, clusterId);
        this.backend = ClusterMetaStoreFactory.create(storeKey, id, configuration);
        LOGGER.info("create ClusterMetaStore, store key {}, id {}", (Object)storeKey, (Object)id);
    }

    public static synchronized void init(int id, Configuration configuration) {
        if (INSTANCE == null) {
            INSTANCE = new ClusterMetaStore(id, configuration);
        }
    }

    public static ClusterMetaStore getInstance(int id, Configuration configuration) {
        if (INSTANCE == null) {
            ClusterMetaStore.init(id, configuration);
        }
        return INSTANCE;
    }

    public static ClusterMetaStore getInstance() {
        return INSTANCE;
    }

    public static synchronized void close() {
        LOGGER.info("close ClusterMetaStore");
        if (INSTANCE != null) {
            ClusterMetaStore.INSTANCE.backend.close();
            if (ClusterMetaStore.INSTANCE.offsetBackend != null) {
                ClusterMetaStore.INSTANCE.offsetBackend.close();
            }
            INSTANCE = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IClusterMetaKVStore<String, Object> getOffsetBackend() {
        if (this.offsetBackend != null) return this.offsetBackend;
        Class<ClusterMetaStore> clazz = ClusterMetaStore.class;
        synchronized (ClusterMetaStore.class) {
            String storeKey = String.format("%s/%s", CLUSTER_META_NAMESPACE_LABEL, OFFSET_NAMESPACE);
            this.offsetBackend = ClusterMetaStoreFactory.create(storeKey, this.componentId, this.configuration);
            LOGGER.info("create ClusterMetaStore, store key {}, id {}", (Object)storeKey, (Object)this.componentId);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.offsetBackend;
        }
    }

    public ClusterMetaStore savePipeline(Pipeline pipeline) {
        this.save(ClusterMetaKey.PIPELINE, pipeline);
        return this;
    }

    public ClusterMetaStore savePipelineTasks(List<Integer> taskIndices) {
        this.save(ClusterMetaKey.PIPELINE_TASKS, taskIndices);
        return this;
    }

    public void saveWindowId(Long windowId) {
        IClusterMetaKVStore<String, Object> offsetBackend = this.getOffsetBackend();
        offsetBackend.put(ClusterMetaKey.WINDOW_ID.name(), windowId);
        offsetBackend.flush();
    }

    public ClusterMetaStore saveCycle(Object cycle) {
        this.save(ClusterMetaKey.CYCLE, cycle);
        return this;
    }

    public ClusterMetaStore saveEvent(List<IEvent> event) {
        this.save(ClusterMetaKey.EVENTS, event);
        return this;
    }

    public ClusterMetaStore saveWorkers(WorkerSnapshot workers) {
        this.save(ClusterMetaKey.WORKERS, workers);
        return this;
    }

    public ClusterMetaStore saveComponentIndex(String key, Set<Integer> componentIds) {
        this.save(key, componentIds);
        return this;
    }

    public Pipeline getPipeline() {
        return (Pipeline)this.get(ClusterMetaKey.PIPELINE);
    }

    public List<Integer> getPipelineTasks() {
        return (List)this.get(ClusterMetaKey.PIPELINE_TASKS);
    }

    public Long getWindowId() {
        IClusterMetaKVStore<String, Object> offsetBackend = this.getOffsetBackend();
        return (Long)offsetBackend.get(ClusterMetaKey.WINDOW_ID.name());
    }

    public Object getCycle() {
        return this.get(ClusterMetaKey.CYCLE);
    }

    public List<IEvent> getEvents() {
        return (List)this.get(ClusterMetaKey.EVENTS);
    }

    public WorkerSnapshot getWorkers() {
        return (WorkerSnapshot)this.get(ClusterMetaKey.WORKERS);
    }

    public Set<Integer> getComponentIds(String componentIndexLabel) {
        return (Set)this.get(componentIndexLabel);
    }

    public void flush() {
        this.backend.flush();
    }

    public void clean() {
    }

    private <T> void save(ClusterMetaKey key, T value) {
        this.backend.put(key.name(), value);
    }

    private <T> void save(String key, T value) {
        this.backend.put(key, value);
    }

    private <T> T get(ClusterMetaKey key) {
        return (T)this.backend.get(key.name());
    }

    private <T> T get(String key) {
        return (T)this.backend.get(key);
    }

    public static enum ClusterMetaKey {
        PIPELINE,
        PIPELINE_TASKS,
        WINDOW_ID,
        CYCLE,
        EVENTS,
        WORKERS;

    }
}

